import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '@xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { DASHBOARD_LIST_SUFFIX } from '../../xlr-dashboard-constants';

interface AddDashboardPagePortalProps {
    folderId?: string;
}

export const AddDashboardPagePortal = ({ folderId }: AddDashboardPagePortalProps) => {
    const handleCancelClick = () => {
        if (folderId) {
            window.location.href = `#/folders/${folderId}/dashboards`;
        } else {
            window.location.href = `#/${DASHBOARD_LIST_SUFFIX}`;
        }
    };

    return (
        <ActionToolbarPortalContainer helpLink="how-to/configure-custom-dashboards">
            <DotButton onClick={handleCancelClick} type="outlined">
                Cancel
            </DotButton>
        </ActionToolbarPortalContainer>
    );
};
