import React from 'react';
import { DotTypography } from '@digital-ai/dot-components';
import { dashboardsMock } from '../../../mocks';
import { ReactWrapper, mountWithTheme } from '@xlr-ui/tests/unit/testing-utils';
import { DashboardDeleteDialogContent, DashboardDeleteDialogContentProps } from './dashboard-delete-dialog-content.component';

describe('DashboardDeleteDialogContent', () => {
    let wrapper: ReactWrapper;
    const dashboard = dashboardsMock[0];

    const defaultProps: DashboardDeleteDialogContentProps = {
        dashboard,
    };

    const getDotTypography = () => wrapper.find(DotTypography);

    const mount = (props = defaultProps) => {
        wrapper = mountWithTheme(<DashboardDeleteDialogContent {...props} />);
    };

    it('should render typography with correct data', () => {
        mount();
        const typography = getDotTypography();
        expect(typography).toExist();
        const typographyProps = getDotTypography().props();
        expect(typographyProps.variant).toBe('body1');
        expect(typography).toHaveText(`You are about to DELETE "${dashboard.title}".Click on Delete dashboard to confirm this action.`);
    });
});
