import React from 'react';
import { DotTypography } from '@digital-ai/dot-components';
import { Dashboard } from '../../../types';

export interface DashboardDeleteDialogContentProps {
    dashboard: Dashboard;
}

export const DashboardDeleteDialogContent = ({ dashboard }: DashboardDeleteDialogContentProps) => {
    return (
        <>
            <DotTypography variant="body1">
                You are about to <strong>DELETE {`"${dashboard.title}"`}</strong>.
                <br />
                Click on <strong>Delete dashboard</strong> to confirm this action.
            </DotTypography>
        </>
    );
};
