import React from 'react';
import { DotSkeleton } from '@digital-ai/dot-components';
import { DashboardCardsSkeleton } from './dashboard-cards.skeleton';
import { ReactWrapper, mountWithTheme } from '@xlr-ui/tests/unit/testing-utils';

describe('DashboardCardsSkeleton', () => {
    let wrapper: ReactWrapper;

    const mount = () => {
        wrapper = mountWithTheme(<DashboardCardsSkeleton />);
    };

    const getTitleSkeleton = () => wrapper.findWhere((node) => node.is(DotSkeleton) && node.props()['data-testid'] === 'title-skeleton');
    const getSearchSkeleton = () => wrapper.findWhere((node) => node.is(DotSkeleton) && node.props()['data-testid'] === 'search-skeleton');
    const getCardSkeletons = () => wrapper.findWhere((node) => node.is(DotSkeleton) && node.props()['data-testid'] === 'card-skeleton');

    afterEach(() => jest.resetAllMocks());

    it('should render skeletons', () => {
        mount();
        const titleSkeleton = getTitleSkeleton();
        expect(titleSkeleton).toExist();
        const titleSkeletonProps = titleSkeleton.props();
        expect(titleSkeletonProps.height).toBe(40);
        expect(titleSkeletonProps.width).toBe(210);
        expect(titleSkeletonProps.variant).toBe('rectangular');

        const searchSkeleton = getSearchSkeleton();
        expect(searchSkeleton).toExist();
        const searchSkeletonProps = searchSkeleton.props();
        expect(searchSkeletonProps.height).toBe(40);
        expect(searchSkeletonProps.width).toBe(220);
        expect(searchSkeletonProps.variant).toBe('rectangular');

        const cardSkeletons = getCardSkeletons();
        expect(cardSkeletons.length).toBe(20);
        cardSkeletons.forEach((cardSkeleton) => {
            const cardSkeletonProps = cardSkeleton.props();
            expect(cardSkeletonProps.height).toBe(58);
            expect(cardSkeletonProps.variant).toBe('rectangular');
        });
    });
});
