package com.xebialabs.xlrelease.plugins.dashboard.repository

import com.xebialabs.deployit.checks.Checks.IncorrectArgumentException
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard
import com.xebialabs.xlrelease.repository.{Ids, PersistenceInterceptor, ReleaseRepository}
import org.springframework.stereotype.Component

@Component
class ReleaseDashboardPersistenceInterceptor(releaseDashboardRepository: ReleaseDashboardRepository,
                                             releaseRepository: ReleaseRepository) extends PersistenceInterceptor[Dashboard] {

  releaseDashboardRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Dashboard): Unit = {
    validateNoDashboardForWorkflow(ci)
  }

  override def onUpdate(ci: Dashboard): Unit = {
    validateNoDashboardForWorkflow(ci)
  }

  private def validateNoDashboardForWorkflow(dashboard: Dashboard): Unit = {
    if (dashboard.isReleaseDashboard) {
      val releaseId = Ids.releaseIdFrom(dashboard.getId)
      val isWorkflow = releaseRepository.isWorkflow(releaseId)
      if (isWorkflow) {
        throw new IncorrectArgumentException("Dashboards are not supported for workflows")
      }
    }
  }
}
