import React from 'react';
import { DotInputText, DotTypography } from '@digital-ai/dot-components';
import { Dashboard } from '../../../types';
import { TITLE_MAX_LENGTH } from './dashboard-dialog.component';
import './dashboard-duplicate-dialog-content.component.less';

export interface DashboardDuplicateDialogContentProps {
    dashboard: Dashboard;
    errorMessage?: string;
    onNameChange: (name: string) => void;
    title: string;
}

export const DashboardDuplicateDialogContent = ({ dashboard, errorMessage, onNameChange, title }: DashboardDuplicateDialogContentProps) => {
    return (
        <div className="duplicate-dashboard-dialog-content">
            <DotTypography data-testid="duplicate-dashboard-typography" variant="body1">
                You are about to <strong>Duplicate {`"${dashboard.title}"`}</strong>.
                <br />
                Provide a new name for your duplicated dashboard.
            </DotTypography>
            <DotInputText
                autoFocus={true}
                defaultValue={title}
                error={!!errorMessage}
                helperText={errorMessage}
                id="dashboard-name"
                label="Dashboard name"
                maxLength={TITLE_MAX_LENGTH}
                name="dashboard-name"
                onChange={(e) => onNameChange(e.target.value)}
                persistentLabel={true}
            />
        </div>
    );
};
