package com.xebialabs.xlrelease.plugins.dashboard.repository

import com.xebialabs.deployit.security.Role
import com.xebialabs.xlrelease.plugins.dashboard.domain.{Dashboard, Tile}
import com.xebialabs.xlrelease.repository.Ids.releaseIdFrom
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.util.Try

@Service
class DelegatingDashboardRepository @Autowired()(sqlDashboardRepository: SqlDashboardRepository,
                                                 releaseDashboardRepository: ReleaseDashboardActorRepositoryAdapter) extends DashboardRepository {

  override def exists(dashboardId: String): Boolean = getRepository(dashboardId).exists(dashboardId)

  override def search(parentId: String, title: String, principals: Iterable[String], roles: Iterable[Role], enforcePermissions: Boolean = true): Seq[Dashboard] =
    getRepository(parentId).search(parentId, title, principals, roles, enforcePermissions)

  override def findDashboardById(dashboardId: String): Dashboard = getRepository(dashboardId).findDashboardById(dashboardId)

  override def createDashboard(dashboard: Dashboard): Dashboard = getRepository(dashboard.getParentId).createDashboard(dashboard)

  override def updateDashboard(dashboard: Dashboard): Dashboard = getRepository(dashboard.getId).updateDashboard(dashboard)

  override def deleteDashboard(dashboardId: String): Unit = getRepository(dashboardId).deleteDashboard(dashboardId)

  override def findTileById(tileId: String): Tile = getRepository(tileId).findTileById(tileId)

  override def updateTile(tile: Tile): Tile = getRepository(tile.getId).updateTile(tile)

  override def getSecurityUid(dashboardId: String): Option[String] = getRepository(dashboardId).getSecurityUid(dashboardId)

  private def getRepository(id: String): DashboardRepository =
    Try(releaseIdFrom(id)).map(_ => releaseDashboardRepository).getOrElse(sqlDashboardRepository)
}
