package com.xebialabs.xlrelease.plugins.dashboard.repository

import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.plugins.dashboard.repository.sql.persistence.DashboardPersistence
import com.xebialabs.xlrelease.repository.{FolderRepository, PersistenceInterceptor}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class DashboardPersistenceInterceptor @Autowired()(dashboardPersistence: DashboardPersistence,
                                                   folderRepository: FolderRepository)
  extends PersistenceInterceptor[Folder] {

  folderRepository.registerPersistenceInterceptor(this)

  override def onDelete(ciId: String): Unit = {
    dashboardPersistence.deleteByParentId(ciId)
  }
}
