import { call, put } from 'redux-saga/effects';
import { LinkUnderline } from '@digital-ai/dot-components';
import { navigation } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import { registerSidebarProvider, SidebarProvider } from '../../../../../../../../../core/xlr-ui/app/features/custom-ui/sidebar.registry';
import { MainNavigationItem, UiExtensionsService } from '../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import getAngularService from '../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { DASHBOARD_LIST_SUFFIX } from './xlr-dashboard-constants';

const { setBackItem, updateBreadcrumbs, setSidebarMenu, setLastBreadcrumb } = navigation.actions;

export class NewDashboardSidebarProvider implements SidebarProvider {
    isSupported(path: string): boolean {
        return path.startsWith('/dashboards/new');
    }

    *provide() {
        const uiExtensionsService: UiExtensionsService = yield call(getAngularService, 'UiExtensionsService');
        const mainMenuItems: MainNavigationItem[] = yield call([uiExtensionsService, uiExtensionsService.getMainMenuItems]);
        const reportsTabs = mainMenuItems.find((item) => item.id === 'xlrelease.menu.Reports')?.items || [];
        const dashboardTabs = reportsTabs.find((tab) => tab.id === 'xlrelease.menu.Dashboards')?.items || [];

        const dashboardSidebar = dashboardTabs
            .filter((tab) => tab.permitted)
            .map((tab) => ({
                text: tab.label,
                startIconId: tab.icon,
                pathSuffix: tab.pathSuffix,
                selected: tab.pathSuffix === DASHBOARD_LIST_SUFFIX,
            }));

        const breadcrumbs = [
            { text: 'Dashboards', href: `/dashboards`, underline: 'hover' as LinkUnderline },
            { text: 'Custom dashboards', href: `/${DASHBOARD_LIST_SUFFIX}`, underline: 'hover' as LinkUnderline },
            { text: 'New dashboard' },
        ];

        yield put(setSidebarMenu({ sidebarMenu: dashboardSidebar, withFolder: false }));
        yield put(setLastBreadcrumb(undefined));
        yield put(updateBreadcrumbs(breadcrumbs));

        yield put(
            setBackItem({
                pathSuffix: DASHBOARD_LIST_SUFFIX,
                title: 'Custom dashboards',
                text: 'Custom dashboards',
            }),
        );
    }
}

registerSidebarProvider(new NewDashboardSidebarProvider(), 0);
