import React from 'react';
import { Provider } from 'react-redux';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { store } from '../';
import { ApplicationTileComponent, ApplicationTileProps } from './application-tile.component';

export const ApplicationTile = ({ description, title }: ApplicationTileProps) => {
    return (
        <DotThemeProvider>
            <Provider store={store}>
                <ApplicationTileComponent description={description} title={title} />
            </Provider>
        </DotThemeProvider>
    );
};
