import pluralize from 'pluralize';
import { HomeTemplate } from '../active-template-tile.component';
import { HomeRelease } from '../../../ReleaseTile/components/active-release-tile.component';
import { HomeWorkflow } from '../../../../../../../../../../../core/xlr-ui/app/features/workflow/ducks/workflow.reducer';

export const getReleaseIdForUrl = (templateOrRelease: HomeTemplate | HomeRelease | HomeWorkflow): string => {
    const cleanFolderPath = templateOrRelease.folderPath.slice(1).replaceAll('/', '-');
    const folderPath = cleanFolderPath.length > 0 ? `${cleanFolderPath}-` : '';
    const folderId = templateOrRelease.folderId.length > 1 ? `${templateOrRelease.folderId}-` : '';
    return `${folderPath}${folderId}${templateOrRelease.releaseId}`;
};

export const getReleaseCountText = (releaseCount: number): string => {
    return `${releaseCount === 0 ? 'no' : releaseCount} ${pluralize('release', releaseCount)} started`;
};
