import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { TileButtonsRow, TileButtonsRowProps } from './tile-buttons-row.component';
import { primaryButton, secondaryButton, tertiaryButton } from './tile-buttons-row.mock';

describe('TileButtonsRow', () => {
    const alignButtonsRight = false;

    const defaultProps: TileButtonsRowProps = { alignButtonsRight, primaryButton, secondaryButton, tertiaryButton };

    const mount = (props: TileButtonsRowProps = defaultProps) => {
        return mountWithTheme(<TileButtonsRow {...props} />);
    };

    const getPrimaryButton = (wrapper: ReactWrapper) => wrapper.find(DotButton).at(0);
    const getSecondaryButton = (wrapper: ReactWrapper) => wrapper.find(DotButton).at(1);
    const getTertiaryButton = (wrapper: ReactWrapper) => wrapper.find(DotButton).at(2);
    const getTileButtonsRow = (wrapper: ReactWrapper) => wrapper.find('.tile-buttons-row');

    it('should render properly', () => {
        const wrapper = mount();
        const primaryButtonProps = getPrimaryButton(wrapper).props();
        expect(primaryButtonProps.children).toBe(primaryButton.buttonCaption);
        expect(primaryButtonProps.type).toBe(primaryButton.buttonType);
        expect(primaryButtonProps.onClick).toBe(primaryButton.onClick);
        const secondaryButtonProps = getSecondaryButton(wrapper).props();
        expect(secondaryButtonProps.children).toBe(secondaryButton.buttonCaption);
        expect(secondaryButtonProps.type).toBe(secondaryButton.buttonType);
        expect(secondaryButtonProps.onClick).toBe(secondaryButton.onClick);
        const tertiaryButtonProps = getTertiaryButton(wrapper).props();
        expect(tertiaryButtonProps.children).toBe(tertiaryButton.buttonCaption);
        expect(tertiaryButtonProps.type).toBe(tertiaryButton.buttonType);
        expect(tertiaryButtonProps.onClick).toBe(tertiaryButton.onClick);
    });

    it('should not render secondary button', () => {
        const wrapper = mount({ ...defaultProps, secondaryButton: undefined });
        expect(getSecondaryButton(wrapper)).not.toExist();
    });

    it('should not render tertiary button', () => {
        const wrapper = mount({ ...defaultProps, tertiaryButton: undefined });
        expect(getTertiaryButton(wrapper)).not.toExist();
    });

    it('should not render tertiary button if secondary button is not present', () => {
        const wrapper = mount({ ...defaultProps, secondaryButton: undefined });
        expect(getTertiaryButton(wrapper)).not.toExist();
    });

    it('should have proper class name when alignButtonsRight is true', () => {
        const wrapper = mount({ ...defaultProps, alignButtonsRight: true });
        expect(getTileButtonsRow(wrapper)).toHaveClassName('align-buttons-right');
    });

    it('should handle click', () => {
        const wrapper = mount({ ...defaultProps, primaryButton, secondaryButton });
        getPrimaryButton(wrapper).invoke('onClick')?.('' as never);
        expect(primaryButton.onClick).toHaveBeenCalled();
        getSecondaryButton(wrapper).invoke('onClick')?.('' as never);
        expect(secondaryButton.onClick).toHaveBeenCalled();
    });
});
