package com.xebialabs.xlrelease.plugins.dashboard.views

import com.xebialabs.xlrelease.plugins.dashboard.service.{AppHomeTileFolderCount, AppHomeTileRow}

import java.util.{Date, List => JList}
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

class ApplicationHomeTileRowView(val app: AppHomeTileRow) {
  @BeanProperty var appId: String = app.appId
  @BeanProperty var appName: String = app.appName
  @BeanProperty var appEnvironment: String = app.appEnvironment
  @BeanProperty var appCreateDate: Date = app.appCreateDate
  @BeanProperty var folderName: String = app.folderName
  @BeanProperty var folderId: String = app.folderId
  @BeanProperty var folderPath: String = app.folderPath
}

class ApplicationHomeTileFolderView(val app: AppHomeTileFolderCount) {
  @BeanProperty var total: Int = app.amount
  @BeanProperty var folderName: String = app.folderName
  @BeanProperty var folderId: String = app.folderId
  @BeanProperty var folderPath: String = app.folderPath
}

class ApplicationHomeTileView(val totalApps: Int, val apps: Seq[ApplicationHomeTileRowView], val counters: Seq[ApplicationHomeTileFolderView]) {
  @BeanProperty var total: Int = totalApps
  @BeanProperty var applications: JList[ApplicationHomeTileRowView] = apps.asJava
  @BeanProperty var folders: JList[ApplicationHomeTileFolderView] = counters.asJava
}
