import React from 'react';
import { Provider } from 'react-redux';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { store } from '../';
import { ReleaseTileComponent, ReleaseTileProps } from './release-tile.component';

export const ReleaseTile = ({ description, title }: ReleaseTileProps) => {
    return (
        <DotThemeProvider>
            <Provider store={store}>
                <ReleaseTileComponent description={description} title={title} />
            </Provider>
        </DotThemeProvider>
    );
};
