import { calculateStatusColors, calculateStatusIcon, formatReleaseDuration, formatStatusText } from './helpers';
import colors from '../../../../../../../../../../../core/xlr-ui/app/js/colors';

describe('release tile helper functions', () => {
    describe('calculateStatusIcon', () => {
        it('should return correct icon for different release statuses', () => {
            expect(calculateStatusIcon('planned')).toBe('circle-paused');
            expect(calculateStatusIcon('paused')).toBe('circle-paused');

            expect(calculateStatusIcon('in_progress')).toBe('progress');

            expect(calculateStatusIcon('failing')).toBe('warning-solid');

            expect(calculateStatusIcon('failed')).toBe('error-solid');
            expect(calculateStatusIcon('aborted')).toBe('error-solid');

            expect(calculateStatusIcon('completed')).toBe('check-solid');

            expect(calculateStatusIcon('template')).toBe('');
        });
    });

    describe('calculateStatusColors', () => {
        it('should return correct colors for different release statuses', () => {
            expect(calculateStatusColors('planned')).toStrictEqual({ background: colors.background, border: colors.lightgray });
            expect(calculateStatusColors('aborted')).toStrictEqual({ background: colors.background, border: colors.lightgray });

            expect(calculateStatusColors('paused')).toStrictEqual({ background: colors.backgroundBlue, border: colors.blue });
            expect(calculateStatusColors('in_progress')).toStrictEqual({ background: colors.backgroundBlue, border: colors.blue });

            expect(calculateStatusColors('failing')).toStrictEqual({ background: colors.warningBackground, border: colors.orange });

            expect(calculateStatusColors('failed')).toStrictEqual({ background: colors.errorBackground, border: colors.red });

            expect(calculateStatusColors('completed')).toStrictEqual({ background: colors.successBackground, border: colors.green });

            expect(calculateStatusColors('template')).toStrictEqual({ background: colors.background, border: colors.lightgray });
        });
    });

    describe('formatStatusText', () => {
        it('should return text in correct format for release statuses', () => {
            expect(formatStatusText('planned')).toStrictEqual('Planned');
            expect(formatStatusText('aborted')).toStrictEqual('Aborted');
            expect(formatStatusText('paused')).toStrictEqual('Paused');
            expect(formatStatusText('in_progress')).toStrictEqual('In progress');
            expect(formatStatusText('failing')).toStrictEqual('Failing');
            expect(formatStatusText('failed')).toStrictEqual('Failed');
            expect(formatStatusText('completed')).toStrictEqual('Completed');
        });
    });

    describe('formatReleaseDuration', () => {
        it('should return duration text in correct format', () => {
            expect(formatReleaseDuration(0, 0, 0)).toStrictEqual('0m');
            expect(formatReleaseDuration(0, 0, 1)).toStrictEqual('1m');
            expect(formatReleaseDuration(0, 8, 480)).toStrictEqual('8h ');
            expect(formatReleaseDuration(2, 48, 2880)).toStrictEqual('2d ');
            expect(formatReleaseDuration(2, 56, 3360)).toStrictEqual('2d 8h ');
            expect(formatReleaseDuration(2, 48, 2891)).toStrictEqual('2d 11m');
            expect(formatReleaseDuration(0, 2, 131)).toStrictEqual('2h 11m');
        });
    });
});
