import React, { ReactNode } from 'react';
import { DotDivider } from '@digital-ai/dot-components';
import { TileButtonsRow } from './tile-buttons-row.component';
import { ButtonWithLink } from './common-card-tile.component';
import { CommonTileHeader } from './common-tile-header.component';
import './common-active-tile.component.less';

interface CommonActiveTileProps {
    avatarIcon: string;
    content: ReactNode;
    headerEndContent?: ReactNode;
    primaryButton: ButtonWithLink;
    secondaryButton?: ButtonWithLink;
    subtitle: string;
    title: string;
}

export const CommonActiveTile = ({ avatarIcon, content, headerEndContent, primaryButton, secondaryButton, subtitle, title }: CommonActiveTileProps) => {
    return (
        <div className="active-tile">
            <CommonTileHeader avatarIcon={avatarIcon} endContent={headerEndContent} subtitle={subtitle} title={title} />
            <DotDivider />
            <div className="active-tile-content">{content}</div>
            <div className="active-tile-footer">
                <DotDivider />
                <TileButtonsRow alignButtonsRight primaryButton={primaryButton} secondaryButton={secondaryButton} />
            </div>
        </div>
    );
};
