import React from 'react';
import { ButtonWithLink, CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import { workflow } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/ducks/workflow.reducer';
import { useAppDispatch } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';

const workflowsImgSrc = 'static/@project.version@/styles/img/workflows_forms.svg';

export interface WorkflowTileProps {
    description: string;
    title: string;
}

const { init } = workflow.actions;

export const WorkflowTile = ({ description, title }: WorkflowTileProps) => {
    const dispatch = useAppDispatch();

    const handlePrimaryButtonClick = () => {
        dispatch(init());
    };

    const primaryButton: ButtonWithLink = {
        buttonCaption: 'Open workflow catalog',
        onClick: handlePrimaryButtonClick,
        buttonType: 'outlined',
    };

    return <CommonCardTileComponent description={description} imageLink={workflowsImgSrc} isMarkdown={true} primaryButton={primaryButton} title={title} />;
};
