package com.xebialabs.xlrelease.plugins.dashboard

import com.fasterxml.jackson.databind.ObjectMapper
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind._
import com.xebialabs.deployit.plugin.api.reflect.{Descriptor, PropertyDescriptor}
import com.xebialabs.xlrelease.repository.ConfigurationRepository

import java.util
import scala.jdk.CollectionConverters._
import scala.language.implicitConversions

package object views {

  implicit def tileToView = TileView.apply _

  implicit def viewToTile(view: TileView)(implicit configurationRepository: ConfigurationRepository, objectMapper: ObjectMapper) = TileView.toTile(view)

  def convertValue(descriptor: Descriptor, propertyName: String, propertValue: AnyRef)(implicit objectMapper: ObjectMapper): (String, Any) = {
    if (propertValue == null) {
      (propertyName, propertValue)
    } else {
      val pd = descriptor.getPropertyDescriptor(propertyName)
      val transformedValue: Any = pd.getKind match {
        case CI => convertToCi(pd)(propertValue)
        case SET_OF_CI | SET_OF_STRING =>
          new util.HashSet(propertValue.asInstanceOf[util.Collection[_]].asScala.map(convertToCi(pd)).asJavaCollection)
        case LIST_OF_CI | LIST_OF_STRING =>
          new util.ArrayList(propertValue.asInstanceOf[util.Collection[_]].asScala.map(convertToCi(pd)).asJavaCollection)
        case _ => propertValue
      }
      (propertyName, transformedValue)
    }
  }

  def convertToCi(pd: PropertyDescriptor)(itemValue: Any)(implicit objectMapper: ObjectMapper): Any = {
    if (pd.isAsContainment && pd.getReferencedType != null) {
      objectMapper.convertValue(itemValue, pd.getReferencedType.getDescriptor.getClazz)
    } else {
      itemValue
    }
  }

}
