import { Category, Workflow } from '../../../../../../../../../../../../../core/xlr-ui/app/types';

const cryptoArray = new Uint32Array(1);

export interface WorkflowsByCategory {
    [key: string]: Array<Workflow>;
}

interface StartAndSpan {
    span: number;
    start: number;
}

interface CellProps {
    lg: StartAndSpan;
    md: StartAndSpan;
    sm: StartAndSpan;
    xs: StartAndSpan;
}

export const OTHER_CATEGORY = 'Other';
export const groupWorkflowsByCategory = (categories: Array<Category>, workflows: Array<Workflow>): WorkflowsByCategory => {
    const categoriesKeys: WorkflowsByCategory = { [OTHER_CATEGORY]: [] };
    for (const category of categories) {
        categoriesKeys[category.title] = [];
    }
    return workflows.reduce((acc, workflow) => {
        if (workflow.categories.length > 0) {
            workflow.categories.forEach((category) => {
                if (acc[category]) {
                    addWorkflowIntoCategory(category, acc, workflow);
                } else {
                    addWorkflowIntoCategory(OTHER_CATEGORY, acc, workflow);
                }
            });
        } else {
            addWorkflowIntoCategory(OTHER_CATEGORY, acc, workflow);
        }

        return acc;
    }, categoriesKeys);
};

const addWorkflowIntoCategory = (category: string, workflowList: WorkflowsByCategory, workflow: Workflow) => {
    // only add the workflow once
    if (!workflowList[category].find((w) => w.id === workflow.id)) {
        workflowList[category].push(workflow);
    }
};

export const calculateCellProps = (index: number): CellProps => {
    const sizeConstants = {
        lg: {
            columns: 12,
            cards: 3,
        },
        md: {
            columns: 12,
            cards: 2,
        },
        sm: {
            columns: 8,
            cards: 2,
        },
        xs: {
            columns: 4,
            cards: 1,
        },
    };

    return {
        lg: {
            start: (index % sizeConstants.lg.cards) * (sizeConstants.lg.columns / sizeConstants.lg.cards) + 1,
            span: sizeConstants.lg.columns / sizeConstants.lg.cards,
        },
        md: {
            start: (index % sizeConstants.md.cards) * (sizeConstants.md.columns / sizeConstants.md.cards) + 1,
            span: sizeConstants.md.columns / sizeConstants.md.cards,
        },
        sm: {
            start: (index % sizeConstants.sm.cards) * (sizeConstants.sm.columns / sizeConstants.sm.cards) + 1,
            span: sizeConstants.sm.columns / sizeConstants.sm.cards,
        },
        xs: {
            start: (index % sizeConstants.xs.cards) * (sizeConstants.xs.columns / sizeConstants.xs.cards) + 1,
            span: sizeConstants.xs.columns / sizeConstants.xs.cards,
        },
    };
};

export const getRandomInt = (min: number, max: number): number => {
    const minCeiled = Math.ceil(min);
    const maxFloored = Math.floor(max);
    window.crypto.getRandomValues(cryptoArray);
    const randomNumber = cryptoArray[0] / (0xffffffff + 1);
    return Math.floor(randomNumber * (maxFloored - minCeiled + 1)) + minCeiled;
};
