import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { RootState } from '../../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { Category, Folder, Workflow } from '../../../../../../../../../../../core/xlr-ui/app/types';

export interface WorkflowPagination {
    itemsPerPage: number;
    page: number;
}

export interface WorkflowTileSearch extends WorkflowPagination {
    author?: string;
    categories?: string[];
    folderId?: string;
    searchInput?: string;
}

export interface WorkflowTileState {
    categories: Array<Category>;
    folders: Array<Folder>;
    isLoadingCategories: boolean;
    isLoadingFolders: boolean;
    isLoadingWorkflows: boolean;
    totalWorkflows: number;
    workflowDialogError?: string;
    workflowDialogOpen?: string;
    workflowTileSearch?: WorkflowTileSearch;
    workflows: Array<Workflow>;
}

export const initialState: WorkflowTileState = {
    categories: [],
    folders: [],
    isLoadingCategories: false,
    isLoadingFolders: false,
    isLoadingWorkflows: false,
    totalWorkflows: 0,
    workflows: [],
};

export interface RunWorkflowAction {
    folderId: string;
    workflow: Workflow;
}

export const workflowTile = createSlice({
    name: 'workflowTile',
    initialState,
    reducers: {
        init: (state) => {
            state.isLoadingWorkflows = true;
            state.isLoadingFolders = true;
            state.isLoadingCategories = true;
            state.workflowDialogError = undefined;
            state.workflowDialogOpen = undefined;
        },
        setCategories: (state, action: PayloadAction<Array<Category>>) => {
            state.categories = action.payload;
            state.isLoadingCategories = false;
        },
        setFolders: (state, action: PayloadAction<Array<Folder>>) => {
            state.folders = action.payload;
            state.isLoadingFolders = false;
        },
        setWorkflows: (state, action: PayloadAction<Array<Workflow>>) => {
            state.workflows = action.payload;
            state.isLoadingWorkflows = false;
        },
        filterWorkflowTile: (_state, _action: PayloadAction<WorkflowTileSearch>) => noop(),
        setWorkflowTileSearch: (state, action: PayloadAction<WorkflowTileSearch | undefined>) => {
            state.workflowTileSearch = action.payload;
        },
        setDialogOpen: (state, action: PayloadAction<string | undefined>) => {
            state.workflowDialogOpen = action.payload;
            state.workflowDialogError = undefined;
        },
        setDialogError: (state, action: PayloadAction<string | undefined>) => {
            state.workflowDialogError = action.payload;
        },
        setTotalWorkflows: (state, action: PayloadAction<number>) => {
            state.totalWorkflows = action.payload;
        },
        runWorkflow: (_state, _action: PayloadAction<RunWorkflowAction>) => noop(),
    },
});

export const getWorkflowTileState = (state: RootState): WorkflowTileState => state.workflowTile;
