import React from 'react';
import { CssCell, CssGrid, DotSkeleton, DotTypography } from '@digital-ai/dot-components';
import { calculateCellProps, getRandomInt } from '../helper';
import { WorkflowCardSkeleton } from './workflow-card-skeleton.component';
import './workflow-skeletons.component.less';

export const WorkflowSkeletons = () => {
    return (
        <>
            {[...Array(getRandomInt(1, 3))].map((_value, index) => (
                <div className="workflow-skeletons-category" key={index}>
                    <DotTypography className="workflow-skeletons-category-title" variant="h3">
                        <DotSkeleton variant="rectangular">
                            <DotTypography variant="h3">Category Title</DotTypography>
                        </DotSkeleton>
                    </DotTypography>
                    <CssGrid>
                        {[...Array(getRandomInt(1, 3))].map((_cellValue, cellIndex) => {
                            const props = calculateCellProps(cellIndex);
                            return (
                                <CssCell {...props} key={cellIndex}>
                                    <WorkflowCardSkeleton />
                                </CssCell>
                            );
                        })}
                    </CssGrid>
                </div>
            ))}
        </>
    );
};
