import React from 'react';
import { CheckboxSkeleton } from './checkbox-skeleton.component';
import { getRandomInt } from '../helper';
import './workflow-categories-skeleton.component.less';

export const WorkflowCategoriesSkeleton = () => {
    return (
        <div className="workflow-categories-skeleton">
            <CheckboxSkeleton />
            <div className="workflow-category-checkbox-items">
                {[...Array(getRandomInt(1, 7))].map((_, index: number) => (
                    <CheckboxSkeleton key={index} />
                ))}
            </div>
        </div>
    );
};
