import capitalize from 'lodash/capitalize';
import colors from '../../../../../../../../../../../core/xlr-ui/app/js/colors';
import {
    getHoursRemainderWithinDay,
    getMinutesRemainderWithinHour,
} from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/scheduling/helper';

export const calculateStatusIcon = (status: string) => {
    switch (status) {
        case 'planned':
        case 'paused':
            return 'circle-paused';
        case 'in_progress':
            return 'progress';
        case 'failing':
            return 'warning-solid';
        case 'failed':
        case 'aborted':
            return 'error-solid';
        case 'completed':
            return 'check-solid';
        default:
            return '';
    }
};

export const calculateStatusColors = (status: string): { background: string; border: string } => {
    switch (status) {
        case 'planned':
        case 'aborted':
            return { background: colors.background, border: colors.lightgray };
        case 'paused':
        case 'in_progress':
            return { background: colors.backgroundBlue, border: colors.blue };
        case 'failing':
            return { background: colors.warningBackground, border: colors.orange };
        case 'failed':
            return { background: colors.errorBackground, border: colors.red };
        case 'completed':
            return { background: colors.successBackground, border: colors.green };
        default:
            return { background: colors.background, border: colors.lightgray };
    }
};

export const formatStatusText = (status: string) => {
    // capitalize first letter and remove underscores
    return capitalize(status).replace('_', ' ');
};

export const formatReleaseDuration = (days: number, hours: number, minutes: number) => {
    const daysText = days > 0 ? `${days}d ` : '';
    const hoursText = getHoursRemainderWithinDay(hours) > 0 ? `${getHoursRemainderWithinDay(hours)}h ` : '';
    const minutesText = getMinutesRemainderWithinHour(minutes) > 0 ? `${getMinutesRemainderWithinHour(minutes)}m` : '';
    return `${daysText}${hoursText}${minutesText}` || '0m';
};
