import React from 'react';
import { DotCardContent, DotCardHeader, DotTypography } from '@digital-ai/dot-components';
import { TextAreaMarkdown } from '../../../../../../../../../core/xlr-ui/app/react/components/markdown/textarea-markdown.component';
import { TileButtonsRow } from './tile-buttons-row.component';
import './common-card-tile.component.less';

export type ButtonType = 'destructive' | 'primary' | 'outlined' | 'text';

export interface ButtonWithLink {
    buttonCaption: string;
    buttonType: ButtonType;
    'data-testid'?: string;
    onClick: () => void;
}

export interface CommonCardTileComponentProps {
    description: string;
    imageLink?: string;
    isMarkdown: boolean;
    primaryButton: ButtonWithLink;
    secondaryButton?: ButtonWithLink;
    title: string;
}

export const MAX_DESCRIPTION_SIZE = 13_000;
export const MAX_DESCRIPTION_SIZE_WARNING = `The text is longer than ${MAX_DESCRIPTION_SIZE} characters, can't be displayed`;

export const CommonCardTileComponent = ({ description, imageLink, isMarkdown, primaryButton, secondaryButton, title }: CommonCardTileComponentProps) => {
    const descriptionSanitized = isMarkdown && description.length > MAX_DESCRIPTION_SIZE ? MAX_DESCRIPTION_SIZE_WARNING : description;

    return (
        <div className="card-tile">
            <div>
                <DotCardHeader title={title} />
                <DotCardContent className="card-tile-content">
                    {isMarkdown ? (
                        <TextAreaMarkdown
                            inputId="card-tile-input"
                            isReadOnly={true}
                            maxRows={Number.MAX_SAFE_INTEGER}
                            name="card-tile"
                            rows={5}
                            text={descriptionSanitized}
                        />
                    ) : (
                        <DotTypography variant="body1">{description}</DotTypography>
                    )}
                    {imageLink && <img alt="tile image" src={imageLink}></img>}
                </DotCardContent>
            </div>
            <TileButtonsRow primaryButton={primaryButton} secondaryButton={secondaryButton} />
        </div>
    );
};
