import { all, call, put, takeLatest } from 'redux-saga/effects';
import { PayloadAction } from '@reduxjs/toolkit';
import { IHttpResponse } from 'angular';
import { httpGET, httpPOST } from '../../../../../../../../../../../core/xlr-ui/app/features/common/services/http';
import { RunWorkflowAction, workflowTile } from './workflow-tile.reducer';
import { Category, Folder, Workflow } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { Page } from '../../../../../../../../../../../core/xlr-ui/app/js/http/backend';
import getAngularService from '../../../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { FoldersService } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { applicationManagement } from '../../../../../../../../../../xlr-application-pipelines-module/src/main/resources/web/include/applications-management/ducks/managed-application.reducer';
import { Template } from '../../../../../../../../../../xlr-application-pipelines-module/src/main/resources/web/include/applications-management/managed-application.types';

const { init, setCategories, setFolders, setWorkflows, runWorkflow } = workflowTile.actions;
const { createRelease } = applicationManagement.actions;

export function* initSaga() {
    const categories: Array<Category> = yield call(searchCategories);
    yield put(setCategories(categories));
    const workflows: Array<Workflow> = yield call(searchWorkflows);
    yield put(setWorkflows(workflows));
    // let's leave folders for the end in case it takes long time
    const folders: Array<Folder> = yield call(searchFolders);
    yield put(setFolders(folders));
}

export function* searchCategories() {
    // TODO pagination
    const { data }: IHttpResponse<Page<Category>> = yield call(httpGET, 'api/v1/categories');
    return data.content;
}

export function* searchFolders() {
    const foldersService: FoldersService = yield call(getAngularService, 'FoldersService');
    // we do not check permissions same way as we don't in create release/template pages :shrug:
    const folders: IHttpResponse<Array<Folder>> = yield call([foldersService, foldersService.getListOrCachedPromise], false);
    return folders.data;
}

export function* searchWorkflows() {
    // TODO pagination
    const { data }: IHttpResponse<Page<Workflow>> = yield call(httpPOST, 'api/v1/workflows', {});
    return data.content;
}

export function* runWorkflowSaga(action: PayloadAction<RunWorkflowAction>) {
    const { folderId, workflow } = action.payload;
    const { data: template }: IHttpResponse<Template> = yield call(httpGET, `releases/${workflow.id}`);
    yield put(createRelease({ template, parentId: folderId }));
}

export default function* workflowTileSaga() {
    yield all([takeLatest(init, initSaga), takeLatest(runWorkflow, runWorkflowSaga)]);
}
