import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { RootState } from '../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { HomeTemplate } from '../components/active-template-tile.component';

export interface TemplateTileState {
    isLoading: boolean;
    topTemplates: Array<HomeTemplate>;
}

export const initialState: TemplateTileState = {
    isLoading: true,
    topTemplates: [],
};

export const templateTile = createSlice({
    name: 'templateTile',
    initialState,
    reducers: {
        loadTopTemplates: (state) => {
            state.isLoading = true;
        },
        setTopTemplates: (state, action: PayloadAction<Array<HomeTemplate>>) => {
            state.topTemplates = action.payload;
            state.isLoading = false;
        },
    },
});

export const getTemplateTileState = (state: RootState): TemplateTileState => state.templateTile;
