import { workflowTile, initialState } from './workflow-tile.reducer';

const { init, setCategories, setFolders, setWorkflows, runWorkflow } = workflowTile.actions;
describe('workflowTile.reducer', () => {
    it('should have initial state', () => {
        expect(workflowTile.name).toBe('workflowTile');
        expect(Object.keys(workflowTile.actions)).toStrictEqual(['init', 'setCategories', 'setFolders', 'setWorkflows', 'runWorkflow']);
        expect(workflowTile.reducer(undefined, { type: 'default' })).toMatchObject(initialState);
    });

    describe('reducers', () => {
        const afterInitState = workflowTile.reducer(initialState, init());

        describe('init', () => {
            it('should update state', () => {
                const state = workflowTile.reducer(initialState, init());
                expect(state).toStrictEqual(afterInitState);
            });
        });

        describe('setCategories', () => {
            it('should update state', () => {
                const state = workflowTile.reducer(afterInitState, setCategories(['a', 'b'] as never));
                expect(state).toStrictEqual({
                    categories: ['a', 'b'],
                    folders: [],
                    isLoadingCategories: false,
                    isLoadingFolders: true,
                    isLoadingWorkflows: true,
                    workflows: [],
                });
            });
        });
        describe('setFolders', () => {
            it('should update state', () => {
                const state = workflowTile.reducer(afterInitState, setFolders(['a', 'b'] as never));
                expect(state).toStrictEqual({
                    categories: [],
                    folders: ['a', 'b'],
                    isLoadingCategories: true,
                    isLoadingFolders: false,
                    isLoadingWorkflows: true,
                    workflows: [],
                });
            });
        });
        describe('setWorkflows', () => {
            it('should update state', () => {
                const state = workflowTile.reducer(afterInitState, setWorkflows(['a', 'b'] as never));
                expect(state).toStrictEqual({
                    categories: [],
                    folders: [],
                    isLoadingCategories: true,
                    isLoadingFolders: true,
                    isLoadingWorkflows: false,
                    workflows: ['a', 'b'],
                });
            });
        });
        describe('runWorkflow', () => {
            it('should not update state', () => {
                const state = workflowTile.reducer(initialState, runWorkflow({} as never));
                expect(state).toStrictEqual(initialState);
            });
        });
    });
});
