import React, { useState } from 'react';
import { DotDrawer, DotIconButton, DotTabs, TabProps } from '@digital-ai/dot-components';
import { WorkflowMarketplace } from './marketplace/workflow-marketplace.component';
import { WorkflowCatalog } from './catalog/workflow-catalog.component';
import './workflow-drawer.component.less';

export interface WorkflowDrawerProps {
    isOpen: boolean;
    onClose: () => void;
}

export const WorkflowDrawer = ({ isOpen, onClose }: WorkflowDrawerProps) => {
    // for now we only show 1 tab, check this commit to get back the marketplace whenever is ready to be implemented
    const [selectedTab, _setSelectedTab] = useState(0);
    const tabs: Array<TabProps> = [{ label: 'Workflow catalog' }];

    return (
        <DotDrawer
            PaperProps={{
                style: {
                    top: '48px',
                    padding: 0,
                },
            }}
            anchor="bottom"
            className="workflow-drawer"
            open={isOpen}
        >
            {isOpen && (
                <>
                    <div className="workflow-drawer-header">
                        <DotTabs tabs={tabs} />
                        <DotIconButton iconId="close" onClick={onClose} tooltip="Close" />
                    </div>
                    <div className="workflow-drawer-content">
                        {selectedTab === 0 && <WorkflowCatalog />}
                        {selectedTab === 1 && <WorkflowMarketplace />}
                    </div>
                </>
            )}
        </DotDrawer>
    );
};
