import { SagaIterator } from 'redux-saga';
import { all, call, put, takeLatest } from 'redux-saga/effects';
import { httpGET } from '../../../../../../../../../../core/xlr-ui/app/features/common/services/http';
import { templateTile } from './template-tile.reducer';
import templateTileSaga, { loadTopTemplatesSaga } from './template-tile.saga';
import { HomeTemplate } from '../components/active-template-tile.component';

const { loadTopTemplates, setTopTemplates } = templateTile.actions;

describe('templateTileSaga', () => {
    it('should yield all effects', () => {
        const gen: SagaIterator = templateTileSaga();
        expect(gen.next().value).toStrictEqual(all([takeLatest(loadTopTemplates, loadTopTemplatesSaga)]));
        expect(gen.next().done).toBe(true);
    });

    describe('loadTopTemplatesSaga', () => {
        const topTemplates: Array<HomeTemplate> = [
            {
                releaseId: 'releaseId',
                releaseTitle: 'Test Release',
                folderName: 'test',
                folderId: 'folderId',
                folderPath: '/',
                lastEditedByUser: 1688372003150,
                releaseCount: 0,
            },
        ];

        it('should load and set top templates and adjust loading state', () => {
            const gen: SagaIterator = loadTopTemplatesSaga();
            expect(gen.next().value).toStrictEqual(call(httpGET, 'home-tile/templates'));
            expect(gen.next({ data: topTemplates }).value).toMatchObject(put(setTopTemplates(topTemplates)));
            expect(gen.next().done).toBeTruthy();
        });
    });
});
