import React, { KeyboardEvent, MouseEvent, useEffect, useState } from 'react';
import moment from 'moment';
import { DotChip, DotIcon, DotIconButton, DotMenu, DotTooltip, MenuItemProps } from '@digital-ai/dot-components';
import { MenuItem } from '../../../../../../../../../../core/xlr-ui/app/react/components/menu-item/menu-item.component';
import { HomeTemplate } from './active-template-tile.component';
import './active-template-tile.component.less';

interface TemplateListItemEndIconProps {
    onOptionsClick: (id: string) => void;
    selected: boolean;
    template: HomeTemplate;
    urlTemplateId: string;
}

export const menuItemRelease = 'menu-item-release';
export const menuItemEdit = 'menu-item-edit';

export const TemplateListItemEndIcon = ({ onOptionsClick, selected, template, urlTemplateId }: TemplateListItemEndIconProps) => {
    const [isMenuOpen, setMenuOpen] = useState(selected);
    const [dropdownAnchorEl, setDropdownAnchorEl] = useState<HTMLElement | null>(null);

    useEffect(() => {
        if (!selected) {
            setMenuOpen(false);
        }
    }, [selected]);

    const openTemplateOptionsMenu = (event: MouseEvent<HTMLElement>) => {
        setDropdownAnchorEl(event.currentTarget);
        setMenuOpen(!isMenuOpen);
        onOptionsClick(template.releaseId);
    };

    const menuItems: Array<MenuItemProps> = [
        { children: <MenuItem iconId="play" label="Start release" />, key: menuItemRelease },
        { children: <MenuItem iconId="edit" label="Edit template" />, key: menuItemEdit },
    ];

    const onSelect = (event: MouseEvent | KeyboardEvent, _menuId: string, itemKey: string) => {
        event.stopPropagation();
        if (itemKey === menuItemRelease) {
            window.location.href = `#/releases/create?fromTemplateId=${urlTemplateId}`;
        }
        if (itemKey === menuItemEdit) {
            window.location.href = `#/templates/${urlTemplateId}`;
        }
    };

    return (
        <>
            <DotTooltip data-testid="active-tile-chip-tooltip" title={`Last time updated ${moment(template.lastEditedByUser).format('Do MMM YYYY')}`}>
                <DotChip size="small" startIcon={<DotIcon iconId="calendar" />}>
                    {moment(template.lastEditedByUser).fromNow()}
                </DotChip>
            </DotTooltip>
            <DotIconButton
                className="active-tile-end-icon-button"
                iconId="options"
                onClick={(e) => {
                    e.stopPropagation();
                    openTemplateOptionsMenu(e);
                }}
            />
            <DotMenu
                anchorEl={dropdownAnchorEl || undefined}
                dense
                disablePortal
                id={template.releaseId}
                menuItems={menuItems}
                menuPlacement="left"
                onLeave={() => setMenuOpen(false)}
                onSelect={onSelect}
                open={isMenuOpen}
            />
        </>
    );
};
