import pluralize from 'pluralize';
import { HomeTemplate } from '../active-template-tile.component';

export const getUrlTemplateIdFromHomeTemplate = (template: HomeTemplate): string => {
    const cleanFolderPath = template.folderPath.slice(1);
    const folderPath = cleanFolderPath.length > 0 ? `${cleanFolderPath}-` : '';
    const folderId = template.folderId.length > 1 ? `${template.folderId}-` : '';
    return `${folderPath}${folderId}${template.releaseId}`;
};

export const getReleaseCountText = (releaseCount: number): string => {
    return `${releaseCount === 0 ? 'no' : releaseCount} ${pluralize('release', releaseCount)} started`;
};
