import React, { useState } from 'react';
import { DotAvatar, DotDivider, DotList, DotThemeProvider, DotTypography } from '@digital-ai/dot-components';
import { TileButtonsRow } from '../../CommonCardTile/tile-buttons-row.component';
import { ButtonWithLink } from '../../CommonCardTile/common-card-tile.component';
import { TemplateListItemEndIcon } from './template-list-item-end-icon.component';
import { getReleaseCountText, getUrlTemplateIdFromHomeTemplate } from './helpers/helpers';
import './active-template-tile.component.less';

export interface HomeTemplate {
    folderId: string;
    folderName: string;
    folderPath: string;
    lastEditedByUser: number;
    releaseCount: number;
    releaseId: string;
    releaseTitle: string;
}

interface ActiveTemplateTileProps {
    primaryButton: ButtonWithLink;
    secondaryButton?: ButtonWithLink;
    templates: Array<HomeTemplate>;
    title: string;
}

export const ActiveTemplateTile = ({ primaryButton, secondaryButton, templates, title }: ActiveTemplateTileProps) => {
    const [selectedEndIcon, setSelectedEndIcon] = useState<string>('');

    const generateTemplates = () => {
        return templates.map((template) => {
            const templateId = getUrlTemplateIdFromHomeTemplate(template);
            const releaseCountText = getReleaseCountText(template.releaseCount);
            return {
                endIcon: (
                    <TemplateListItemEndIcon
                        onOptionsClick={(id) => setSelectedEndIcon(id)}
                        selected={selectedEndIcon === template.releaseId}
                        template={template}
                        urlTemplateId={templateId}
                    />
                ),
                onClick: () => {
                    window.location.href = `#/templates/${templateId}`;
                },
                primaryText: template.releaseTitle,
                secondaryText: `${template.folderName} (${releaseCountText})`,
            };
        });
    };

    return (
        <DotThemeProvider>
            <div className="active-tile">
                <div className="active-tile-header">
                    <DotAvatar alt="template-tile" iconId="template" type="icon" />
                    <div>
                        <DotTypography variant="h2">{title}</DotTypography>
                        <DotTypography className="active-tile-subtitle" variant="body1">
                            Last updated - Most recent 5
                        </DotTypography>
                    </div>
                </div>
                <DotDivider />
                <div className="active-tile-list-labels">
                    <DotTypography variant="subtitle2">Template name</DotTypography>
                    <DotTypography variant="subtitle2">Last time updated</DotTypography>
                </div>
                <DotDivider />
                <DotList className="active-tile-list" items={generateTemplates()} width="100%" />
                <div className="active-tile-footer">
                    <DotDivider />
                    <TileButtonsRow alignButtonsRight primaryButton={primaryButton} secondaryButton={secondaryButton} />
                </div>
            </div>
        </DotThemeProvider>
    );
};
