package com.xebialabs.xlrelease.plugins.dashboard.api.internal

import com.xebialabs.xlrelease.plugins.dashboard.service.HomeTilesQueryService
import com.xebialabs.xlrelease.plugins.dashboard.views.TemplateHomeTileView
import com.xebialabs.xlrelease.user.User
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import java.util.{List => JList}
import javax.ws.rs._
import javax.ws.rs.core.MediaType
import scala.jdk.CollectionConverters._

@Path("/home-tile")
@Controller
@Produces(Array(MediaType.APPLICATION_JSON))
@Consumes(Array(MediaType.APPLICATION_JSON))
class HomeTilesResource @Autowired()(val homeTilesService: HomeTilesQueryService) {

  @GET
  @Path("templates")
  def search(): JList[TemplateHomeTileView] = {
    homeTilesService.findLastEditedTemplates(User.AUTHENTICATED_USER.getName).map(new TemplateHomeTileView(_)).asJava
  }

}
