import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { WorkflowTile } from './workflow-tile.component';
import { CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import * as angularAccessor from '../../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { VariablesInterpolatorFactory } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { initialState, workflow, WorkflowState } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/ducks/workflow.reducer';

const { init } = workflow.actions;

describe('WorkflowTile', () => {
    const getAngularServiceSpy = jest.spyOn(angularAccessor, 'default') as unknown as jest.SpyInstance<VariablesInterpolatorFactory, [name: unknown]>;

    const title = 'Workflows';
    const description = 'Start using workflows to execute small orchestrated set of tasks';
    const dispatch = jest.fn();

    const mount = (state: WorkflowState = initialState) => {
        return mountWithStoreAndTheme(<WorkflowTile description={description} title={title} />, dispatch, { workflow: state });
    };

    const getCommonCardTileComponent = (wrapper: ReactWrapper) => wrapper.find(CommonCardTileComponent);
    const getPrimaryButton = (wrapper: ReactWrapper) => wrapper.find(DotButton).at(0);

    beforeEach(() => {
        getAngularServiceSpy.mockReturnValue({
            interpolateInText: jest.fn().mockReturnValue(''),
        });
    });

    it('should render properly', () => {
        const wrapper = mount();
        const props = getCommonCardTileComponent(wrapper).props();
        expect(props.title).toBe(title);
        expect(props.isMarkdown).toBe(true);
        expect(props.description).toBe(description);
        expect(props.imageLink).toBe('static/23.3.0-903.947/styles/img/workflows_forms.svg');
        expect(props.primaryButton.buttonCaption).toBe('Open workflow catalog');
        expect(props.primaryButton.buttonType).toBe('outlined');
        expect(props.secondaryButton).toBe(undefined);
    });

    describe('buttons', () => {
        it('should handle click event for the primary button', () => {
            const wrapper = mount();
            const button = getPrimaryButton(wrapper);
            button.invoke('onClick')?.('' as never);
            expect(dispatch).toHaveBeenCalledWith(init());
        });
    });
});
