import { Folder } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { HomeApplicationFolder } from '../active-application-tile.component';

export const addCounterToFolders = (folders: Array<Folder>, mappedFolders: { [id: string]: number }) => {
    const formattedFolders: Array<Folder> = [];
    folders.forEach((folder) => {
        formattedFolders.push({
            ...folder,
            title: `${folder.title} (${mappedFolders[folder.id] || 0})`,
            children: folder.children ? addCounterToFolders(folder.children, mappedFolders) : undefined,
        });
    });
    return formattedFolders;
};

export const mapFolders = (folders: Array<HomeApplicationFolder>) => {
    const mappedFolders: { [id: string]: number } = {};
    folders.forEach((folder) => (mappedFolders[`Applications${folder.folderPath.length > 1 ? folder.folderPath : ''}/${folder.folderId}`] = folder.total));
    return mappedFolders;
};
