import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import { ActiveTileSkeleton } from '../../CommonCardTile/active-tile.skeleton';
import * as angularAccessor from '../../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { VariablesInterpolatorFactory } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { initialState as releaseTileInitialState } from './ducks/release-tile.reducer';
import { ReleaseTileComponent, ReleaseTileProps } from './release-tile.component';
import { ActiveReleaseTile } from './active-release-tile.component';

describe('ReleaseTileComponent', () => {
    const getAngularServiceSpy = jest.spyOn(angularAccessor, 'default') as unknown as jest.SpyInstance<VariablesInterpolatorFactory, [name: unknown]>;

    const dispatch = jest.fn();

    const title = 'Releases';
    const description = 'Test release description';

    const defaultProps: ReleaseTileProps = {
        title,
        description,
    };

    const defaultState = {
        releaseTile: { ...releaseTileInitialState, isLoading: false },
    };

    const mount = (props: ReleaseTileProps = defaultProps, state = defaultState) => {
        return mountWithStoreAndTheme(<ReleaseTileComponent {...props} />, dispatch, state);
    };

    const getCommonCardTileComponent = (wrapper: ReactWrapper) => wrapper.find(CommonCardTileComponent);
    const getFirstButton = (wrapper: ReactWrapper) => wrapper.find(DotButton).at(0);
    const getSecondButton = (wrapper: ReactWrapper) => wrapper.find(DotButton).at(1);
    const getActiveReleaseTile = (wrapper: ReactWrapper) => wrapper.find(ActiveReleaseTile);
    const getActiveTileSkeleton = (wrapper: ReactWrapper) => wrapper.find(ActiveTileSkeleton);

    beforeEach(() => {
        getAngularServiceSpy.mockReturnValue({
            interpolateInText: jest.fn().mockReturnValue(''),
        });
    });

    it('should render with correct props', () => {
        const wrapper = mount();
        const props = getCommonCardTileComponent(wrapper).props();
        expect(props.title).toBe(title);
        expect(props.description).toBe(description);
        expect(props.imageLink).toBe('static/23.3.0-825.100/styles/img/timeline_monochromatic.svg');
        expect(props.primaryButton.buttonCaption).toBe('View releases');
        expect(props.primaryButton.buttonType).toBe('text');
        expect(props.secondaryButton?.buttonCaption).toBe('Start release');
        expect(props.secondaryButton?.buttonType).toBe('outlined');
        expect(getActiveReleaseTile(wrapper)).not.toExist();
        expect(getActiveTileSkeleton(wrapper)).not.toExist();
    });

    it('should handle click event', () => {
        const wrapper = mount();
        const firstButton = getFirstButton(wrapper);
        firstButton.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/releases`);
        const secondButton = getSecondButton(wrapper);
        secondButton.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/releases/create?fromHome=true`);
    });

    it('should show active tile skeleton if loading', () => {
        const wrapper = mount(defaultProps, { ...defaultState, releaseTile: { ...releaseTileInitialState, isLoading: true } });
        expect(getActiveTileSkeleton(wrapper)).toExist();
    });
});
