import React from 'react';
import { DotButton, DotDrawer, DotIconButton } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { WorkflowTile } from './workflow-tile.component';
import { CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import * as angularAccessor from '../../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { VariablesInterpolatorFactory } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { initialState } from './ducks/workflow-tile.reducer';

describe('WorkflowTile', () => {
    const getAngularServiceSpy = jest.spyOn(angularAccessor, 'default') as unknown as jest.SpyInstance<VariablesInterpolatorFactory, [name: unknown]>;

    const title = 'Workflows';
    const description = 'Start using workflows to execute small orchestrated set of tasks';

    const mount = () => {
        return mountWithStoreAndTheme(<WorkflowTile description={description} title={title} />, jest.fn(), { workflowTile: initialState });
    };

    const getCommonCardTileComponent = (wrapper: ReactWrapper) => wrapper.find(CommonCardTileComponent);
    const getPrimaryButton = (wrapper: ReactWrapper) => wrapper.find(DotButton).at(0);
    const getCloseButton = (wrapper: ReactWrapper) => getWorkflowDrawer(wrapper).find('.workflow-drawer-header').find(DotIconButton);
    const getWorkflowDrawer = (wrapper: ReactWrapper) => wrapper.find(DotDrawer);

    beforeEach(() => {
        getAngularServiceSpy.mockReturnValue({
            interpolateInText: jest.fn().mockReturnValue(''),
        });
    });

    it('should render properly', () => {
        const wrapper = mount();
        const props = getCommonCardTileComponent(wrapper).props();
        expect(props.title).toBe(title);
        expect(props.isMarkdown).toBe(true);
        expect(props.description).toBe(description);
        expect(props.imageLink).toBe('static/23.3.0-721.113/styles/img/workflows_forms.svg');
        expect(props.primaryButton.buttonCaption).toBe('Run workflow');
        expect(props.primaryButton.buttonType).toBe('outlined');
        expect(props.secondaryButton).toBe(undefined);
    });

    describe('buttons', () => {
        it('should handle click event for the primary button', () => {
            const wrapper = mount();
            const button = getPrimaryButton(wrapper);
            expect(getWorkflowDrawer(wrapper).props().open).toBe(false);
            button.invoke('onClick')?.('' as never);
            expect(getWorkflowDrawer(wrapper).props().open).toBe(true);
        });

        it('should close the drawer', () => {
            const wrapper = mount();
            getPrimaryButton(wrapper).invoke('onClick')?.('' as never);
            getCloseButton(wrapper).invoke('onClick')?.('' as never);
            expect(getWorkflowDrawer(wrapper).props().open).toBe(false);
        });
    });
});
