import React from 'react';
import { DotAvatar, DotDivider, DotList, DotTypography } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ActiveTemplateTile, HomeTemplate } from './active-template-tile.component';
import { primaryButton, secondaryButton } from '../../CommonCardTile/tile-buttons-row.mock';
import { TileButtonsRow } from '../../CommonCardTile/tile-buttons-row.component';

describe('ActiveTemplateTile', () => {
    const title = 'Templates';
    const templates: Array<HomeTemplate> = [
        {
            releaseId: 'releaseId',
            releaseTitle: 'Test Release',
            folderName: 'test',
            folderId: 'folderId',
            folderPath: '/',
            lastEditedByUser: 1688372003150,
            releaseCount: 0,
        },
    ];

    const mount = () => {
        return mountWithTheme(<ActiveTemplateTile primaryButton={primaryButton} secondaryButton={secondaryButton} templates={templates} title={title} />);
    };

    const getTitleAvatar = (wrapper: ReactWrapper) => wrapper.find(DotAvatar).at(0);
    const getTitle = (wrapper: ReactWrapper) => wrapper.find(DotTypography).at(0);
    const getSubtitle = (wrapper: ReactWrapper) => wrapper.find(DotTypography).at(1);
    const getListLabelsRow = (wrapper: ReactWrapper) => wrapper.find('.active-tile-list-labels').find(DotTypography);
    const getList = (wrapper: ReactWrapper) => wrapper.find(DotList);
    const getTileButtonsRow = (wrapper: ReactWrapper) => wrapper.find(TileButtonsRow);

    it('should render with correct props', () => {
        const wrapper = mount();

        const avatarProps = getTitleAvatar(wrapper).props();
        expect(avatarProps.alt).toBe('template-tile');
        expect(avatarProps.iconId).toBe('template');
        expect(avatarProps.type).toBe('icon');

        const titleProps = getTitle(wrapper).props();
        expect(titleProps.variant).toBe('h2');
        expect(titleProps.children).toBe(title);

        const subtitleProps = getSubtitle(wrapper).props();
        expect(subtitleProps.className).toBe('active-tile-subtitle');
        expect(subtitleProps.variant).toBe('body1');
        expect(subtitleProps.children).toBe('Last updated - Most recent 5');

        expect(getListLabelsRow(wrapper).at(0)).toHaveText('Template name');
        expect(getListLabelsRow(wrapper).at(1)).toHaveText('Last time updated');

        const listProps = getList(wrapper).props();
        expect(listProps.className).toBe('active-tile-list');
        expect(listProps.width).toBe('100%');

        const tileButtonsRowProps = getTileButtonsRow(wrapper).props();
        expect(tileButtonsRowProps.primaryButton).toBe(primaryButton);
        expect(tileButtonsRowProps.alignButtonsRight).toBe(true);
        expect(tileButtonsRowProps.secondaryButton).toBe(secondaryButton);

        expect(wrapper.find(DotDivider)).toHaveLength(3);
    });
});
