import React from 'react';
import { DotButton, DotCardFooter } from '@digital-ai/dot-components';
import classNames from 'classnames';
import { ButtonWithLink } from './common-card-tile.component';
import './tile-buttons-row.component.less';

export interface TileButtonsRowProps {
    alignButtonsRight?: boolean;
    primaryButton: ButtonWithLink;
    secondaryButton?: ButtonWithLink;
}

export const TileButtonsRow = ({ alignButtonsRight, primaryButton, secondaryButton }: TileButtonsRowProps) => {
    return (
        <DotCardFooter className={classNames('tile-buttons-row', { 'align-buttons-right': alignButtonsRight })}>
            <DotButton className="tile-button" data-testid={primaryButton['data-testid']} onClick={primaryButton.onClick} type={primaryButton.buttonType}>
                {primaryButton.buttonCaption}
            </DotButton>
            {secondaryButton && (
                <DotButton
                    className="tile-button"
                    data-testid={secondaryButton['data-testid']}
                    onClick={secondaryButton.onClick}
                    type={secondaryButton.buttonType}
                >
                    {secondaryButton.buttonCaption}
                </DotButton>
            )}
        </DotCardFooter>
    );
};
