package com.xebialabs.xlrelease.plugins.dashboard.repository.sql.persistence

import com.xebialabs.xlrelease.db.sql.LimitOffset
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.plugins.dashboard.repository.sql.persistence.HomeTilesSqlBuilder.STMT_EDITED_TEMPLATES_BY_USER
import com.xebialabs.xlrelease.repository.sql.persistence.ActivityLogSchema.ACTIVITY_LOGS
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.{FOLDERS, RELEASES}

object HomeTilesSqlBuilder {

  private val releaseAlias = "R"
  private val releaseInnerAlias = "RR"
  private val folderAlias = "F"
  private val activityLogsAlias = "AL"
  val lastEditedByUserAlias = "LAST_EDITED_BY_USER"
  val releasesCounterAlias = "RELEASE_COUNT"

  private val STMT_LAST_ACTIVITY_LOG_BY_USER =
    s"""
       |SELECT DISTINCT dal.${ACTIVITY_LOGS.CONTAINER_ID},
       |       MAX(dal.${ACTIVITY_LOGS.EVENT_TIME}) as ${ACTIVITY_LOGS.EVENT_TIME}
       |FROM ${ACTIVITY_LOGS.TABLE} dal WHERE dal.${ACTIVITY_LOGS.USERNAME} = :username
       |GROUP BY dal.${ACTIVITY_LOGS.CONTAINER_ID}
       |""".stripMargin

  val STMT_EDITED_TEMPLATES_BY_USER: String =
    s"""
       |SELECT
       |   $releaseAlias.${RELEASES.RELEASE_ID},
       |   $releaseAlias.${RELEASES.RELEASE_TITLE},
       |   $folderAlias.${FOLDERS.NAME},
       |   $folderAlias.${FOLDERS.FOLDER_ID},
       |   $folderAlias.${FOLDERS.FOLDER_PATH},
       |   MAX($activityLogsAlias.${ACTIVITY_LOGS.EVENT_TIME}) AS $lastEditedByUserAlias,
       |   COUNT($releaseInnerAlias.${RELEASES.ORIGIN_TEMPLATE_ID}) AS $releasesCounterAlias
       |FROM ${RELEASES.TABLE} $releaseAlias
       |   JOIN ($STMT_LAST_ACTIVITY_LOG_BY_USER) $activityLogsAlias ON $releaseAlias.${RELEASES.RELEASE_ID} = $activityLogsAlias.${ACTIVITY_LOGS.CONTAINER_ID}
       |   JOIN ${FOLDERS.TABLE} $folderAlias ON $releaseAlias.${RELEASES.FOLDER_CI_UID} = $folderAlias.${FOLDERS.CI_UID}
       |   LEFT JOIN  ${RELEASES.TABLE} $releaseInnerAlias ON $releaseInnerAlias.${RELEASES.ORIGIN_TEMPLATE_ID} = $releaseAlias.${RELEASES.RELEASE_ID}
       |WHERE
       |   $releaseAlias.${RELEASES.STATUS} = 'template'
       |GROUP BY $releaseAlias.${RELEASES.RELEASE_ID},
       |         $releaseAlias.${RELEASES.RELEASE_TITLE},
       |         $folderAlias.${FOLDERS.NAME},
       |         $folderAlias.${FOLDERS.FOLDER_ID},
       |         $folderAlias.${FOLDERS.FOLDER_PATH}
       |ORDER BY $lastEditedByUserAlias DESC
       |""".stripMargin

}

class HomeTilesSqlBuilder (implicit val dialect: Dialect) extends LimitOffset {

  def lastTemplatedEditedQuery(limit: Long): String = {
    addLimitAndOffset(STMT_EDITED_TEMPLATES_BY_USER, Some(limit))
  }

}
