import React from 'react';
import { ReactWrapper } from 'enzyme';
import { DotSkeleton } from '@digital-ai/dot-components';
import { mountWithTheme } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ActiveTileSkeleton } from './active-tile.skeleton';

describe('ActiveTileSkeleton', () => {
    let wrapper: ReactWrapper;

    beforeEach(() => {
        wrapper = mountWithTheme(<ActiveTileSkeleton />);
    });

    it('should render skeleton header properly', () => {
        const headerSkeletons = wrapper.find('.active-tile-skeleton-header').find(DotSkeleton);
        expect(headerSkeletons).toHaveLength(3);

        const avatarSkeletonProps = headerSkeletons.at(0).props();
        expect(avatarSkeletonProps.variant).toBe('circular');
        expect(avatarSkeletonProps.height).toBe('40px');
        expect(avatarSkeletonProps.width).toBe('40px');

        const titleSkeletonProps = headerSkeletons.at(1).props();
        expect(titleSkeletonProps.className).toBe('round-border');
        expect(titleSkeletonProps.variant).toBe('rectangular');
        expect(titleSkeletonProps.height).toBe('12px');
        expect(titleSkeletonProps.width).toBe('100%');

        const subtitleSkeletonProps = headerSkeletons.at(2).props();
        expect(titleSkeletonProps.className).toBe('round-border');
        expect(subtitleSkeletonProps.variant).toBe('rectangular');
        expect(subtitleSkeletonProps.height).toBe('10px');
        expect(subtitleSkeletonProps.width).toBe('50%');
    });

    it('should render skeleton content properly', () => {
        const contentSkeletons = wrapper.find('.active-tile-skeleton-content').find(DotSkeleton);
        expect(contentSkeletons).toHaveLength(3);

        contentSkeletons.map((skeleton) => {
            const contentSkeletonProps = skeleton.props();
            expect(contentSkeletonProps.className).toBe('round-border');
            expect(contentSkeletonProps.variant).toBe('rectangular');
            expect(contentSkeletonProps.height).toBe('40px');
            expect(contentSkeletonProps.width).toBe('100%');
        });
    });

    it('should render skeleton footer properly', () => {
        const footerSkeletons = wrapper.find('.active-tile-skeleton-footer').find(DotSkeleton);
        expect(footerSkeletons).toHaveLength(3);

        footerSkeletons.map((skeleton) => {
            const footerSkeletonProps = skeleton.props();
            expect(footerSkeletonProps.className).toBe('round-border');
            expect(footerSkeletonProps.variant).toBe('rectangular');
            expect(footerSkeletonProps.height).toBe('40px');
            expect(footerSkeletonProps.width).toBe('100px');
        });
    });
});
