import pluralize from 'pluralize';
import { DotColumnHeader } from '@digital-ai/dot-components';
import { WorkflowTileToggleEnum } from '../workflow-tile.component';
import { EmptyDataProps } from '../empty-data.component';
import { Workflow } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { HomeWorkflow } from '../../../../../../../../../../../core/xlr-ui/app/features/workflow/ducks/workflow.reducer';

export const calculateTableColumns = (tableType: WorkflowTileToggleEnum): Array<DotColumnHeader> => {
    if (tableType === WorkflowTileToggleEnum.Running) {
        return [
            { id: 'workflowName', label: 'Workflow', truncate: true },
            { id: 'status', label: 'Status', width: '136px' },
            { id: 'started', label: 'Started', width: '136px' },
            { id: 'category', label: 'Category', width: '37%' },
        ];
    } else if (tableType === WorkflowTileToggleEnum.Recent) {
        return [
            { id: 'workflowName', label: 'Workflow', truncate: true },
            { id: 'status', label: 'Status', width: '136px' },
            { id: 'ended', label: 'Ended', width: '136px' },
            { id: 'category', label: 'Category', width: '37%' },
        ];
    } else {
        return [
            { id: 'workflowName', label: 'Workflow', truncate: true },
            { id: 'numberOfExecutions', label: 'No. of executions', width: '152px' },
            { id: 'category', label: 'Category', width: '37%' },
        ];
    }
};

export const calculateWorkflowTileSubtitle = (tableType: WorkflowTileToggleEnum, hoursToDelete?: number) => {
    switch (tableType) {
        case WorkflowTileToggleEnum.MostPopular: {
            if (hoursToDelete !== undefined) {
                const days = Math.floor(hoursToDelete / 24);
                let labelToDisplay = `${days === 1 ? '' : days + ' '}${pluralize('day', days)}`;
                if (days < 1) {
                    labelToDisplay = `${hoursToDelete === 1 ? '' : hoursToDelete + ' '}${pluralize('hour', hoursToDelete)}`;
                }
                return `Account workflows in Last ${labelToDisplay} - Top 5`;
            } else return 'Account workflows in Last 30 days - Top 5';
        }
        case WorkflowTileToggleEnum.Recent:
            return 'Workflow executions - Most recent 5';
        case WorkflowTileToggleEnum.Running:
            return 'Running workflows - 5 oldest';
        default:
            return '';
    }
};

export const calculateEmptyDataInfo = (tableType: WorkflowTileToggleEnum): EmptyDataProps => {
    switch (tableType) {
        case WorkflowTileToggleEnum.MostPopular:
            return {
                imageLink: 'static/23.3.0-1103.100/styles/img/supportdata_maintenance_monochromatic.svg',
                message: 'Information is not available.',
            };
        case WorkflowTileToggleEnum.Recent:
            return {
                imageLink: 'static/23.3.0-1103.100/styles/img/timeline_monochromatic.svg',
                message: 'You do not have workflow executions.',
            };
        case WorkflowTileToggleEnum.Running:
            return {
                imageLink: 'static/23.3.0-1103.100/styles/img/workflows_forms.svg',
                message: 'You do not have running workflows.',
            };
        default:
            return {
                imageLink: '',
                message: '',
            };
    }
};

export const mapToHomeWorkflow = (workflows: Array<Workflow>): Array<HomeWorkflow> => {
    return workflows.map((workflow) => {
        const homeWorkflow: HomeWorkflow = {
            categories: workflow.categories,
            folderId: workflow.folderId,
            folderPath: '',
            logoId: workflow.logo?.id || null,
            numberOfExecutions: workflow.executions,
            releaseId: workflow.id,
            releaseTitle: workflow.title,
        };
        return homeWorkflow;
    });
};
