import React, { useEffect } from 'react';
import { ButtonWithLink, CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import { ActiveTemplateTile } from './active-template-tile.component';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getTemplateTileState, templateTile } from './ducks/template-tile.reducer';
import { ActiveTileSkeleton } from '../../CommonCardTile/active-tile.skeleton';

const { loadTopTemplates } = templateTile.actions;

const templatesImgSrc = 'static/23.3.0-1020.100/styles/img/timeline_monochromatic.svg';

export interface TemplateTileProps {
    description: string;
    title: string;
}

export const TemplateTileComponent = ({ description, title }: TemplateTileProps) => {
    const dispatch = useAppDispatch();
    const { isLoading, topTemplates } = useAppSelector(getTemplateTileState);

    useEffect(() => {
        dispatch(loadTopTemplates());
    }, []);

    const handleFirstButtonClick = () => {
        window.location.href = '#/templates';
    };

    const handleSecondButtonClick = () => {
        window.location.href = '#/templates/create?fromHome=true';
    };

    const primaryButton: ButtonWithLink = {
        buttonCaption: 'View templates',
        onClick: handleFirstButtonClick,
        buttonType: 'text',
    };

    const secondaryButton: ButtonWithLink = {
        buttonCaption: 'Create template',
        onClick: handleSecondButtonClick,
        buttonType: 'outlined',
    };

    const renderTile = () =>
        topTemplates.length > 0 ? (
            <ActiveTemplateTile primaryButton={primaryButton} secondaryButton={secondaryButton} templates={topTemplates} title={title} />
        ) : (
            <CommonCardTileComponent
                description={description}
                imageLink={templatesImgSrc}
                isMarkdown={true}
                primaryButton={primaryButton}
                secondaryButton={secondaryButton}
                title={title}
            />
        );

    return isLoading ? <ActiveTileSkeleton /> : renderTile();
};
