import { HomeTemplate } from '../active-template-tile.component';
import { getReleaseCountText, getReleaseIdForUrl } from './helpers';

describe('template tile helper functions', () => {
    describe('getReleaseIdForUrl', () => {
        const template: HomeTemplate = {
            releaseId: 'releaseId',
            releaseTitle: 'Test Release',
            folderName: 'test',
            folderId: 'folderId',
            folderPath: '/',
            lastEditedByUser: 1688372003150,
            releaseCount: 0,
        };

        it('should return release/template id for the url', () => {
            expect(getReleaseIdForUrl(template)).toBe('folderId-releaseId');
        });

        it('should return release/template id for the url when there is folderPath specified', () => {
            expect(getReleaseIdForUrl({ ...template, folderPath: '/testFolderPath' })).toBe('testFolderPath-folderId-releaseId');
        });

        it('should return release/template id for root releases', () => {
            expect(getReleaseIdForUrl({ ...template, folderId: '/' })).toBe('releaseId');
        });

        it('should return release/template id for nested releases', () => {
            expect(getReleaseIdForUrl({ ...template, folderPath: '/testFolderPath/innerFolderOne/innerFolderTwo' })).toBe(
                'testFolderPath-innerFolderOne-innerFolderTwo-folderId-releaseId',
            );
        });
    });

    describe('getReleaseCountText', () => {
        it('should return correct text when release count is 0', () => {
            expect(getReleaseCountText(0)).toBe('no releases started');
        });

        it('should return correct text when release count is 1', () => {
            expect(getReleaseCountText(1)).toBe('1 release started');
        });

        it('should return correct text when release count is bigger than 1', () => {
            expect(getReleaseCountText(5)).toBe('5 releases started');
        });
    });
});
