/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.repository.SqlDashboardRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001\u0002\u000e\u001c\u0001!B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\to\u0001\u0011\t\u0011)A\u0005c!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003;\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011-\u0003!Q1A\u0005\u00021C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t#\u0002\u0011)\u0019!C\u0001%\"Aa\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005X\u0001\t\u0015\r\u0011\"\u0001Y\u0011!q\u0006A!A!\u0002\u0013I\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u0002=\u0001\t\u0003I\bbBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\tI\f\u0001C\u0005\u0003wCq!!1\u0001\t\u0013\t\u0019MA\tECND'm\\1sIN+7-\u001e:jifT!\u0001H\u000f\u0002\u000fM,'O^5dK*\u0011adH\u0001\nI\u0006\u001c\bNY8be\u0012T!\u0001I\u0011\u0002\u000fAdWoZ5og*\u0011!eI\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001J\u0013\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0014\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-A\tqKJl\u0017n]:j_:\u001c\u0005.Z2lKJ,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003i\u0005\n\u0001b]3dkJLG/_\u0005\u0003mM\u0012\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0003I\u0001XM]7jgNLwN\\\"iK\u000e\\WM\u001d\u0011\u0002\u0017I|G.Z*feZL7-Z\u000b\u0002uA\u00111hP\u0007\u0002y)\u0011A'\u0010\u0006\u0003}\r\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u0001r\u00121BU8mKN+'O^5dK\u0006a!o\u001c7f'\u0016\u0014h/[2fA\u0005Q1/Z2ve\u0016$7)[:\u0016\u0003\u0011\u0003\"!\u0012%\u000e\u0003\u0019S!aR\u0011\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002J\r\nQ1+Z2ve\u0016$7)[:\u0002\u0017M,7-\u001e:fI\u000eK7\u000fI\u0001\u0013a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/F\u0001N!\tYd*\u0003\u0002Py\t\u0011\u0002+\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s\u0003M\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:!\u0003A\u0001XM]7jgNLwN\\#eSR|'/F\u0001T!\tYD+\u0003\u0002Vy\t\u0001\u0002+\u001a:nSN\u001c\u0018n\u001c8FI&$xN]\u0001\u0012a\u0016\u0014X.[:tS>tW\tZ5u_J\u0004\u0013a\u00053bg\"\u0014w.\u0019:e%\u0016\u0004xn]5u_JLX#A-\u0011\u0005icV\"A.\u000b\u0005\u001dk\u0012BA/\\\u0005Y\u0019\u0016\u000f\u001c#bg\"\u0014w.\u0019:e%\u0016\u0004xn]5u_JL\u0018\u0001\u00063bg\"\u0014w.\u0019:e%\u0016\u0004xn]5u_JL\b%\u0001\u0004=S:LGO\u0010\u000b\bC\u000e$WMZ4i!\t\u0011\u0007!D\u0001\u001c\u0011\u0015yS\u00021\u00012\u0011\u0015AT\u00021\u0001;\u0011\u0015\u0011U\u00021\u0001E\u0011\u0015YU\u00021\u0001N\u0011\u0015\tV\u00021\u0001T\u0011\u00159V\u00021\u0001ZQ\ti!\u000e\u0005\u0002lm6\tAN\u0003\u0002n]\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005=\u0004\u0018a\u00024bGR|'/\u001f\u0006\u0003cJ\fQAY3b]NT!a\u001d;\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!^\u0001\u0004_J<\u0017BA<m\u0005%\tU\u000f^8xSJ,G-A\u0006dQ\u0016\u001c7n\u0011:fCR,GC\u0001>~!\tQ30\u0003\u0002}W\t!QK\\5u\u0011\u0015qh\u00021\u0001\u0000\u0003!\u0001\u0018M]3oi&#\u0007\u0003BA\u0001\u0003\u001fqA!a\u0001\u0002\fA\u0019\u0011QA\u0016\u000e\u0005\u0005\u001d!bAA\u0005O\u00051AH]8pizJ1!!\u0004,\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011CA\n\u0005\u0019\u0019FO]5oO*\u0019\u0011QB\u0016\u0002\u0013\rDWmY6FI&$Hc\u0001>\u0002\u001a!1\u00111D\bA\u0002}\f1\u0002Z1tQ\n|\u0017M\u001d3JI\u0006I1\r[3dWZKWm\u001e\u000b\u0004u\u0006\u0005\u0002BBA\u000e!\u0001\u0007q0\u0001\bhKR\u0004VM]7jgNLwN\\:\u0015\t\u0005\u001d\u0012q\n\t\t\u0003S\t\u0019$a\u000e\u0002>5\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0004nkR\f'\r\\3\u000b\u0007\u0005E2&\u0001\u0006d_2dWm\u0019;j_:LA!!\u000e\u0002,\t\u0019Q*\u00199\u0011\u0007m\nI$C\u0002\u0002<q\u0012AAU8mKB1\u0011\u0011FA \u0003\u0007JA!!\u0011\u0002,\t\u00191+\u001a;\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013=\u0003)\u0001XM]7jgNLwN\\\u0005\u0005\u0003\u001b\n9E\u0001\u0006QKJl\u0017n]:j_:DaAH\tA\u0002\u0005E\u0003\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]S$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u00037\n)FA\u0005ECND'm\\1sI\u0006y1/\u0019<f!\u0016\u0014X.[:tS>t7\u000fF\u0002{\u0003CBaA\b\nA\u0002\u0005E\u0013\u0001E2mK\u0006\u0014\b+\u001a:nSN\u001c\u0018n\u001c8t)\rQ\u0018q\r\u0005\u0007\u00037\u0019\u0002\u0019A@\u0002\u0011Y\fG.\u001b3bi\u0016$2A_A7\u0011\u0019qB\u00031\u0001\u0002R\u0005\tb/\u00197jI\u0006$XMU8mK:\u000bW.Z:\u0015\u000bi\f\u0019(! \t\u000f\u0005UT\u00031\u0001\u0002x\u0005I!o\u001c7f\u001d\u0006lWm\u001d\t\u0006\u0003S\tIh`\u0005\u0005\u0003w\nYC\u0001\u0004Ck\u001a4WM\u001d\u0005\b\u0003\u007f*\u0002\u0019AAA\u0003!\tG\u000e\u001c*pY\u0016\u001c\bCBAB\u0003\u001b\u000b9D\u0004\u0003\u0002\u0006\u0006%e\u0002BA\u0003\u0003\u000fK\u0011\u0001L\u0005\u0004\u0003\u0017[\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\u000b\tJA\u0002TKFT1!a#,\u0003E9W\r^!wC&d\u0017M\u00197f%>dWm\u001d\u000b\u0005\u0003\u0003\u000b9\n\u0003\u0004\u001f-\u0001\u0007\u0011\u0011K\u0001\u000eg\u0016$\b+\u001a:nSN\u001c\u0018n\u001c8\u0015\u0013i\fi*a(\u0002\"\u0006\r\u0006bBA;/\u0001\u0007\u0011q\u000f\u0005\b\u0003\u0013:\u0002\u0019AA\"\u0011\u001d\tyh\u0006a\u0001\u0003\u0003Cq!!*\u0018\u0001\u0004\t9+A\u0006qKJl\u0017n]:j_:\u001c\b\u0003CAU\u0003g\u000b9$!.\u000e\u0005\u0005-&\u0002BAW\u0003_\u000bA!\u001e;jY*\u0011\u0011\u0011W\u0001\u0005U\u00064\u0018-\u0003\u0003\u00026\u0005-\u0006CBAU\u0003o\u000b\u0019%\u0003\u0003\u0002B\u0005-\u0016\u0001G2iK\u000e\\G)Y:iE>\f'\u000f\u001a)fe6L7o]5p]R)!0!0\u0002@\"9\u0011\u0011\n\rA\u0002\u0005\r\u0003BBA\u000e1\u0001\u0007q0A\fhKR,eMZ3di&4XmU3dkJLG/_+jIR!\u0011QYAf!\u0011Q\u0013qY@\n\u0007\u0005%7F\u0001\u0004PaRLwN\u001c\u0005\u0007=e\u0001\r!!\u0015)\u0007\u0001\ty\r\u0005\u0003\u0002R\u0006]WBAAj\u0015\r\t)N]\u0001\u000bgR,'/Z8usB,\u0017\u0002BAm\u0003'\u0014qaU3sm&\u001cW\r")
public class DashboardSecurity {
    private final PermissionChecker permissionChecker;
    private final RoleService roleService;
    private final SecuredCis securedCis;
    private final PermissionEnforcer permissionEnforcer;
    private final PermissionEditor permissionEditor;
    private final SqlDashboardRepository dashboardRepository;

    public PermissionChecker permissionChecker() {
        return this.permissionChecker;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public PermissionEditor permissionEditor() {
        return this.permissionEditor;
    }

    public SqlDashboardRepository dashboardRepository() {
        return this.dashboardRepository;
    }

    public void checkCreate(String parentId) {
        String string = (String)Option$.MODULE$.apply((Object)parentId).getOrElse((Function0 & Serializable)() -> PermissionChecker$.MODULE$.GLOBAL_SECURITY_ALIAS());
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (Ids.isReleaseId((String)string)) {
            this.permissionChecker().checkEdit(string);
        } else if (Ids.isFolderId((String)string)) {
            this.permissionChecker().check(XLReleasePermissions.EDIT_DASHBOARD, parentId);
        } else {
            this.permissionChecker().check(XLReleasePermissions.CREATE_DASHBOARD);
        }
    }

    public void checkEdit(String dashboardId) {
        if (Ids.isReleaseId((String)Ids.getParentId((String)dashboardId))) {
            this.permissionChecker().checkEdit(Ids.getParentId((String)dashboardId));
        } else {
            this.checkDashboardPermission(XLReleasePermissions.EDIT_DASHBOARD, dashboardId);
        }
    }

    public void checkView(String dashboardId) {
        if (Ids.isReleaseId((String)Ids.getParentId((String)dashboardId))) {
            this.permissionChecker().checkView(Ids.getParentId((String)dashboardId));
        } else {
            this.checkDashboardPermission(XLReleasePermissions.VIEW_DASHBOARD, dashboardId);
        }
    }

    public Map<Role, scala.collection.mutable.Set<Permission>> getPermissions(Dashboard dashboard) {
        Map map;
        Option<String> option = this.getEffectiveSecurityUid(dashboard);
        if (option instanceof Some) {
            Some some = (Some)option;
            String securityUid = (String)some.value();
            Buffer roles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().readRoleAssignments()).asScala().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().readRoleAssignments(securityUid)).asScala());
            Map permissionsByRole = CollectionConverters$.MODULE$.MapHasAsScala(this.permissionEditor().readPermissions(securityUid)).asScala();
            map = (Map)permissionsByRole.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Role role = (Role)tuple2._1();
                Set permissions = (Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2(roles.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DashboardSecurity.$anonfun$getPermissions$2(role, x$1))).getOrElse((Function0 & Serializable)() -> role), (Object)CollectionConverters$.MODULE$.SetHasAsScala(permissions).asScala());
                return tuple22;
            });
        } else {
            map = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public void savePermissions(Dashboard dashboard) {
        block2: {
            if (!dashboard.isGlobalDashboard()) break block2;
            Option<String> option = this.dashboardRepository().getSecurityUid(dashboard.getId());
            if (option instanceof Some) {
                Some some = (Some)option;
                String securityUid = (String)some.value();
                Seq<Role> roles = this.getAvailableRoles(dashboard);
                java.util.Map permissions = this.permissionEditor().readPermissions(securityUid);
                this.setPermission((Buffer<String>)CollectionConverters$.MODULE$.ListHasAsScala(dashboard.getRoleViewers()).asScala(), XLReleasePermissions.VIEW_DASHBOARD, roles, permissions);
                this.setPermission((Buffer<String>)CollectionConverters$.MODULE$.ListHasAsScala(dashboard.getRoleEditors()).asScala(), XLReleasePermissions.EDIT_DASHBOARD, roles, permissions);
                this.permissionEditor().editPermissions(securityUid, permissions);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void clearPermissions(String dashboardId) {
        Option<String> option = this.dashboardRepository().getSecurityUid(dashboardId);
        if (option instanceof Some) {
            Some some = (Some)option;
            String securityUid = (String)some.value();
            this.permissionEditor().editPermissions(securityUid, new HashMap());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void validate(Dashboard dashboard) {
        Seq<Role> allRoles = this.getAvailableRoles(dashboard);
        this.validateRoleNames((Buffer<String>)CollectionConverters$.MODULE$.ListHasAsScala(dashboard.getRoleViewers()).asScala(), allRoles);
        this.validateRoleNames((Buffer<String>)CollectionConverters$.MODULE$.ListHasAsScala(dashboard.getRoleEditors()).asScala(), allRoles);
    }

    private void validateRoleNames(Buffer<String> roleNames, Seq<Role> allRoles) {
        roleNames.foreach((Function1 & Serializable)roleName -> (Role)allRoles.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DashboardSecurity.$anonfun$validateRoleNames$2(roleName, x$2))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("The role '" + roleName + "' does not exist", new Object[0]);
        }));
    }

    private Seq<Role> getAvailableRoles(Dashboard dashboard) {
        return CollectionConverters$.MODULE$.ListHasAsScala((List)Option$.MODULE$.apply((Object)dashboard.getParentId()).map((Function1 & Serializable)parentId -> this.roleService().getRoles(this.securedCis().getEffectiveSecuredCi(parentId).getSecurityUid())).getOrElse((Function0 & Serializable)() -> this.roleService().getRoles())).asScala().toSeq();
    }

    private void setPermission(Buffer<String> roleNames, Permission permission, Seq<Role> allRoles, java.util.Map<Role, Set<Permission>> permissions) {
        CollectionConverters$.MODULE$.MapHasAsScala(permissions).asScala().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Set rolePermissions = (Set)tuple2._2();
            BoxedUnit boxedUnit = rolePermissions != null ? BoxesRunTime.boxToBoolean((boolean)rolePermissions.remove(permission)) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        ((IterableOnceOps)roleNames.flatMap((Function1 & Serializable)roleName -> allRoles.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DashboardSecurity.$anonfun$setPermission$3(roleName, x$3))))).foreach((Function1 & Serializable)role -> {
            Set rolePermissions = permissions.getOrDefault(role, new HashSet());
            rolePermissions.add(permission);
            return permissions.put((Role)role, rolePermissions);
        });
    }

    private void checkDashboardPermission(Permission permission, String dashboardId) {
        Option<String> securityUid;
        Dashboard dashboard = this.dashboardRepository().findDashboardById(dashboardId);
        String string = dashboard.getOwner();
        String string2 = Permissions.getAuthenticatedUserName();
        if ((string == null ? string2 != null : !string.equals(string2)) && (securityUid = this.getEffectiveSecurityUid(dashboard)).isDefined() && !this.permissionEnforcer().hasLoggedInUserPermission(permission, (String)securityUid.get())) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)dashboardId);
        }
    }

    private Option<String> getEffectiveSecurityUid(Dashboard dashboard) {
        return dashboard.isFolderDashboard() ? Option$.MODULE$.apply((Object)this.securedCis().getEffectiveSecuredCi(dashboard.getParentId()).getSecurityUid()) : (dashboard.isGlobalDashboard() ? this.dashboardRepository().getSecurityUid(dashboard.getId()) : None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$getPermissions$2(Role role$1, Role x$1) {
        String string = x$1.getId();
        String string2 = role$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateRoleNames$2(String roleName$1, Role x$2) {
        String string = x$2.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$setPermission$3(String roleName$2, Role x$3) {
        String string = x$3.getName();
        String string2 = roleName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DashboardSecurity(PermissionChecker permissionChecker, RoleService roleService, SecuredCis securedCis, PermissionEnforcer permissionEnforcer, PermissionEditor permissionEditor, SqlDashboardRepository dashboardRepository) {
        this.permissionChecker = permissionChecker;
        this.roleService = roleService;
        this.securedCis = securedCis;
        this.permissionEnforcer = permissionEnforcer;
        this.permissionEditor = permissionEditor;
        this.dashboardRepository = dashboardRepository;
    }
}

