/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.domain;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Metadata(virtual=true, versioned=false, description="Base type for dashboard tiles")
public class Tile
extends ReleaseExtension {
    public static final String PROPERTY_USER_SPECIFIC_CACHE = "userSpecificCache";
    public static final String PROPERTY_EXPIRATION_TIME = "expirationTime";
    public static final String PROPERTY_MAX_CACHE_ENTRIES = "maxCacheEntries";
    @Property(category="input", description="Title of this tile")
    private String title;
    @Property(required=false, hidden=true, size=Property.Size.MEDIUM, description="Describes the functionality of this tile.")
    private String description;
    @Property(required=true, hidden=true, description="URI of the HTML file to render the summary mode of this tile")
    private String uri;
    @Property(required=false, hidden=true, description="URI pointing to the HTML file to render when we are switching to details view")
    private String detailsUri;
    @Property(required=false, hidden=true, description="URI of the HTML file to render the configuration mode of this tile")
    private String configurationUri;
    @Property(required=false, hidden=true, description="Dashboards that contain this tile by default")
    private List<String> defaultDashboards = new ArrayList<String>();
    @Property(required=false, hidden=true, description="Optional custom classpath location of the tile Jython script")
    private String scriptLocation;
    @Property(required=false, hidden=true, description="Optional custom classpath location of the Jython script for configuring the tile on create")
    private String provisioningScriptLocation;
    @Property(category="gridConfiguration", description="Default width of this tile in number of dashboard columns it occupies")
    private Integer width;
    @Property(category="gridConfiguration", description="Default height of this tile in number of dashboard rows it occupies")
    private Integer height;
    @Property(category="gridConfiguration", description="Row number of this tile on the dashboard")
    private Integer row;
    @Property(category="gridConfiguration", description="Column number of this tile on the dashboard")
    private Integer col;
    @Property(category="cache", required=false, hidden=true, defaultValue="true", description="True if tile data should be cached")
    private boolean cacheEnabled = true;
    @Property(category="cache", required=false, hidden=true, description="True if tile data should be cached per user.")
    private boolean userSpecificCache = false;
    @Property(category="cache", required=false, hidden=true, defaultValue="300", description="Expiration time for a tile cache (in seconds).")
    private Integer expirationTime = 300;
    @Property(category="cache", required=false, hidden=true, defaultValue="500", description="Maximum cache entries.")
    private Integer maxCacheEntries = 500;
    @Property(required=false, hidden=true, defaultValue="false", description="Render content inside the main page without using iframe element.")
    private boolean embedded;
    @Property(required=false, hidden=true, defaultValue="release", description="Determines on which levels the tile can be used.")
    private List<String> supportedScopes = Collections.singletonList(TileScope.RELEASE.getValue());
    @Property
    private Map<String, String> variableMapping = Maps.newHashMap();

    public List<UsagePoint> getVariableUsages() {
        return this.getProperties().stream().map(pd -> new PropertyUsagePoint((ConfigurationItem)this, pd.getName())).collect(Collectors.toList());
    }

    public List<PropertyDescriptor> getProperties() {
        return this.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> "input".equals(pd.getCategory())).collect(Collectors.toList());
    }

    public static Tile newDummy() {
        Tile tile = new Tile();
        tile.setId(null);
        return tile;
    }

    public boolean isSupportedOn(TileScope scope) {
        return this.supportedScopes.contains(scope.getValue());
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getDetailsUri() {
        return this.detailsUri;
    }

    public void setDetailsUri(String detailsUri) {
        this.detailsUri = detailsUri;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public List<String> getDefaultDashboards() {
        return this.defaultDashboards;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getRow() {
        return this.row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public Integer getCol() {
        return this.col;
    }

    public void setCol(Integer col) {
        this.col = col;
    }

    public Map<String, String> getVariableMapping() {
        return this.variableMapping;
    }

    public void setVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = variableMapping;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isUserSpecificCache() {
        return this.userSpecificCache;
    }

    public void setUserSpecificCache(boolean userSpecificCache) {
        this.userSpecificCache = userSpecificCache;
    }

    public Integer getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Integer expirationTime) {
        this.expirationTime = expirationTime;
    }

    public Integer getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(Integer maxCacheEntries) {
        this.maxCacheEntries = maxCacheEntries;
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public String getProvisioningScriptLocation() {
        return this.provisioningScriptLocation;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public List<String> getSupportedScopes() {
        return this.supportedScopes;
    }

    public void setSupportedScopes(List<String> supportedScopes) {
        this.supportedScopes = supportedScopes;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }
}

