/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.github.benmanes.caffeine.cache.Cache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.DecoratorCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardCreatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardDeletedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardUpdatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardScriptContext$;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecoratorCache;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\tmc\u0001\u0002\u0010 \u00011B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!q\u0005A!A!\u0002\u0013y\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tS\u0002\u0011)\u0019!C\u0002U\"A\u0001\u000f\u0001B\u0001B\u0003%1\u000eC\u0003r\u0001\u0011\u0005!\u000fC\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!I\u00111\u000f\u0001\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\t\t\n\u0001C\u0001\u0003'Cq!!'\u0001\t\u0003\tY\nC\u0004\u0002\"\u0002!\t!a)\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAo\u0001\u0011E\u0011q\u001c\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\tY\u000f\u0001C\u0005\u0003[Dq!!=\u0001\t\u0013\t\u0019\u0010C\u0004\u0003\u0010\u0001!IA!\u0005\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(!9!\u0011\u0007\u0001\u0005\n\tM\u0002b\u0002B\u001c\u0001\u0011%!\u0011\b\u0005\b\u0005{\u0001A\u0011\u0002B \u0005A!\u0015m\u001d5c_\u0006\u0014HmU3sm&\u001cWM\u0003\u0002!C\u000591/\u001a:wS\u000e,'B\u0001\u0012$\u0003%!\u0017m\u001d5c_\u0006\u0014HM\u0003\u0002%K\u00059\u0001\u000f\\;hS:\u001c(B\u0001\u0014(\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002)S\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002U\u0005\u00191m\\7\u0004\u0001M\u0011\u0001!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0007\u0003:L(+\u001a4\u0002'\u0011\f7\u000f\u001b2pCJ$'+\u001a9pg&$xN]=\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]\n\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011H\u000e\u0002\u001e\t\u0016dWmZ1uS:<G)Y:iE>\f'\u000f\u001a*fa>\u001c\u0018\u000e^8ss\u0006\tB-Y:iE>\f'\u000fZ*fGV\u0014\u0018\u000e^=\u0011\u0005qjT\"A\u0010\n\u0005yz\"!\u0005#bg\"\u0014w.\u0019:e'\u0016\u001cWO]5us\u0006QB-Y:iE>\f'\u000fZ*fGV\u0014\u0018\u000e^=EK\u000e|'/\u0019;peB\u0011A(Q\u0005\u0003\u0005~\u0011!\u0004R1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z\t\u0016\u001cwN]1u_J\fAbY1dQ\u0016l\u0015M\\1hKJ\u0004\"!\u0012'\u000e\u0003\u0019S!a\u0012%\u0002\u000b\r\f7\r[3\u000b\u0005%S\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003-\u000b1a\u001c:h\u0013\tieI\u0001\u0007DC\u000eDW-T1oC\u001e,'/A\u0006s_2,7+\u001a:wS\u000e,\u0007C\u0001)V\u001b\u0005\t&B\u0001*T\u0003!\u0019XmY;sSRL(B\u0001+(\u0003!!W\r\u001d7ps&$\u0018B\u0001,R\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002\u001bM\u001c'/\u001b9u'\u0016\u0014h/[2f!\tIf,D\u0001[\u0015\tYF,\u0001\u0004ksRDwN\u001c\u0006\u0003;\u0016\naa]2sSB$\u0018BA0[\u0005MQ\u0015\u0010\u001e5p]N\u001b'/\u001b9u'\u0016\u0014h/[2f\u0003!)g/\u001a8u\u0005V\u001cX#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015,\u0013AB3wK:$8/\u0003\u0002hI\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012a\u001b\t\u0003Y:l\u0011!\u001c\u0006\u0003A\u0015J!a\\7\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\rG&LEmU3sm&\u001cW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013M$XO^<ysj\\\bC\u0001\u001f\u0001\u0011\u0015\u00194\u00021\u00015\u0011\u0015Q4\u00021\u0001<\u0011\u0015y4\u00021\u0001A\u0011\u0015\u00195\u00021\u0001E\u0011\u0015q5\u00021\u0001P\u0011\u001596\u00021\u0001Y\u0011\u0015\u00017\u00021\u0001c\u0011\u0015I7\u0002q\u0001lQ\tYQ\u0010E\u0002\u007f\u0003\u0017i\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006b]:|G/\u0019;j_:TA!!\u0002\u0002\b\u00059a-Y2u_JL(bAA\u0005\u0011\u0006)!-Z1og&\u0019\u0011QB@\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AB3ySN$8\u000f\u0006\u0003\u0002\u0014\u0005e\u0001c\u0001\u0018\u0002\u0016%\u0019\u0011qC\u0018\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0004\u0007A\u0002\u0005u\u0011a\u00033bg\"\u0014w.\u0019:e\u0013\u0012\u0004B!a\b\u0002.9!\u0011\u0011EA\u0015!\r\t\u0019cL\u0007\u0003\u0003KQ1!a\n,\u0003\u0019a$o\\8u}%\u0019\u00111F\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\ty#!\r\u0003\rM#(/\u001b8h\u0015\r\tYc\f\u0015\u0004\u0019\u0005U\u0002\u0003BA\u001c\u0003\u0007j!!!\u000f\u000b\t\u0005\u0005\u00111\b\u0006\u0005\u0003{\ty$A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005\u0005\u0013&\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t)%!\u000f\u0003\u000bQKW.\u001a3\u0002\rM,\u0017M]2i)\u0019\tY%!\u001b\u0002nA1\u0011QJA,\u0003;rA!a\u0014\u0002T9!\u00111EA)\u0013\u0005\u0001\u0014bAA+_\u00059\u0001/Y2lC\u001e,\u0017\u0002BA-\u00037\u00121aU3r\u0015\r\t)f\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111M\u0011\u0002\r\u0011|W.Y5o\u0013\u0011\t9'!\u0019\u0003\u0013\u0011\u000b7\u000f\u001b2pCJ$\u0007bBA6\u001b\u0001\u0007\u0011QD\u0001\ta\u0006\u0014XM\u001c;JI\"I\u0011qN\u0007\u0011\u0002\u0003\u0007\u0011QD\u0001\u0006i&$H.\u001a\u0015\u0004\u001b\u0005U\u0012\u0001E:fCJ\u001c\u0007\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\t9H\u000b\u0003\u0002\u001e\u0005e4FAA>!\u0011\ti(!\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005q&\u0003\u0003\u0002\b\u0006}$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tb-\u001b8e\t\u0006\u001c\bNY8be\u0012\u0014\u00150\u00133\u0015\t\u0005u\u0013Q\u0012\u0005\b\u00037y\u0001\u0019AA\u000fQ\ry\u0011QG\u0001\u0010GJ,\u0017\r^3ECND'm\\1sIR!\u0011QLAK\u0011\u0019\u0011\u0003\u00031\u0001\u0002^!\u001a\u0001#!\u000e\u0002\u001fU\u0004H-\u0019;f\t\u0006\u001c\bNY8be\u0012$B!!\u0018\u0002\u001e\"1!%\u0005a\u0001\u0003;B3!EA\u001b\u0003=!W\r\\3uK\u0012\u000b7\u000f\u001b2pCJ$G\u0003BAS\u0003W\u00032ALAT\u0013\r\tIk\f\u0002\u0005+:LG\u000fC\u0004\u0002\u001cI\u0001\r!!\b)\u0007I\t)$A\u000bhKR$\u0015m\u001d5c_\u0006\u0014H\rV3na2\fG/Z:\u0015\t\u0005M\u0016\u0011\u001a\t\u0007\u0003\u001b\n9&!.\u0011\t\u0005]\u0016QY\u0007\u0003\u0003sSA!a/\u0002>\u00069!/\u001a4mK\u000e$(\u0002BA`\u0003\u0003\f1!\u00199j\u0015\r\t\u0019mU\u0001\u0007a2,x-\u001b8\n\t\u0005\u001d\u0017\u0011\u0018\u0002\u000b\t\u0016\u001c8M]5qi>\u0014\bbBAf'\u0001\u0007\u0011QZ\u0001\u0006g\u000e|\u0007/\u001a\t\u0005\u0003?\ny-\u0003\u0003\u0002R\u0006\u0005$!\u0003+jY\u0016\u001c6m\u001c9fQ\r\u0019\u0012QG\u0001\u0010KZL7\r\u001e+jY\u0016\u001c8)Y2iKR!\u0011QUAm\u0011\u0019\u0011C\u00031\u0001\u0002^!\u001aA#!\u000e\u0002;\u0011,7m\u001c:bi\u0016<\u0016\u000e\u001e5FM\u001a,7\r^5wKN+7-\u001e:jif$B!a\u0013\u0002b\"9\u00111]\u000bA\u0002\u0005-\u0013A\u00033bg\"\u0014w.\u0019:eg\u0006Aa/\u00197jI\u0006$X\r\u0006\u0003\u0002&\u0006%\bB\u0002\u0012\u0017\u0001\u0004\ti&A\ttKR|uO\\3s\u0013\u001al\u0015n]:j]\u001e$B!!*\u0002p\"1!e\u0006a\u0001\u0003;\n\u0011cY;se\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197t+\t\t)\u0010\u0005\u0004\u0002x\u0006u(\u0011A\u0007\u0003\u0003sT1!a?0\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\fIP\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\u0011\u0019A!\u0004\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0005\u0013\tA\u0001\\1oO*\u0011!1B\u0001\u0005U\u00064\u0018-\u0003\u0003\u00020\t\u0015\u0011\u0001D2veJ,g\u000e\u001e*pY\u0016\u001cXC\u0001B\n!\u0019\u0011)Ba\u0007\u0003 5\u0011!q\u0003\u0006\u0005\u00053\tI0A\u0004nkR\f'\r\\3\n\t\tu!q\u0003\u0002\u0007\u0005V4g-\u001a:\u0011\u0007A\u0013\t#C\u0002\u0003$E\u0013AAU8mK\u0006\u0011\u0002O]8wSNLwN\u001c#bg\"\u0014w.\u0019:e)\u0011\u0011ICa\f\u0011\u00079\u0012Y#C\u0002\u0003.=\u00121!\u00118z\u0011\u0019\u0011#\u00041\u0001\u0002^\u00051R\r_3dkR,\u0007K]8wSNLwN\\*de&\u0004H\u000f\u0006\u0003\u0002^\tU\u0002B\u0002\u0012\u001c\u0001\u0004\ti&A\fqe>4\u0018n]5p]\u0012\u000b7\u000f\u001b2pCJ$G+\u001b7fgR!\u0011Q\fB\u001e\u0011\u0019\u0011C\u00041\u0001\u0002^\u0005QR\r_3dkR,G+\u001b7f!J|g/[:j_:\u001c6M]5qiR1!\u0011\tB$\u0005\u0013\u0002B!a\u0018\u0003D%!!QIA1\u0005\u0011!\u0016\u000e\\3\t\r\tj\u0002\u0019AA/\u0011\u001d\u0011Y%\ba\u0001\u0005\u0003\nA\u0001^5mK\"\u001a\u0001Aa\u0014\u0011\t\tE#qK\u0007\u0003\u0005'R1A!\u0016I\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u00053\u0012\u0019FA\u0004TKJ4\u0018nY3")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final CacheManager cacheManager;
    private final RoleService roleService;
    private final JythonScriptService scriptService;
    private final XLReleaseEventBus eventBus;
    private final CiIdService ciIdService;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    public boolean exists(String dashboardId) {
        return this.dashboardRepository.exists(dashboardId);
    }

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    public String search$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)new .colon.colon((Object)dashboard, (List)Nil$.MODULE$)));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboard(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardCreatedEvent(createdDashboard));
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboardTiles(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardUpdatedEvent(updatedDashboard));
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardSecurity.clearPermissions(dashboardId);
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.dashboardRepository.deleteDashboard(dashboardId);
        this.eventBus().publish((XLReleaseEvent)new DashboardDeletedEvent(dashboard));
    }

    @Timed
    public Seq<Descriptor> getDashboardTemplates(TileScope scope) {
        return (Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Dashboard.class))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$getDashboardTemplates$2(scope, desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public void evictTilesCache(Dashboard dashboard) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.cacheManager.getCacheNames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)cacheName -> {
            DashboardService.$anonfun$evictTilesCache$1(this, dashboard, cacheName);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava(), (DecoratorCache<DashboardSecurityDecoratorCache>)new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1()).getDecoratorCache(""));
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        if (!dashboard.isReleaseDashboard()) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
        if (dashboard.getAutoRefresh() && (dashboard.getAutoRefreshInterval() == null || Predef$.MODULE$.Integer2int(dashboard.getAutoRefreshInterval()) < 1)) {
            throw new Checks.IncorrectArgumentException("Auto refresh interval must be larger then 0", new Object[]{dashboard.getAutoRefreshInterval()});
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    private Object provisionDashboard(Dashboard dashboard) {
        if (Strings.isNotBlank((String)dashboard.getTemplateLocation())) {
            Dashboard template = (Dashboard)CiSerializerHelper$.MODULE$.deserialize(ScriptHelper.readScript((String)dashboard.getTemplateLocation()), null);
            dashboard.setTiles(template.getTiles());
        }
        return Strings.isNotBlank((String)dashboard.getScriptLocation()) ? this.executeProvisionScript(dashboard) : BoxedUnit.UNIT;
    }

    private Dashboard executeProvisionScript(Dashboard dashboard) {
        Dashboard dashboard2;
        if (dashboard.hasConfigurationScript()) {
            XlrScriptContext scriptContext = DashboardScriptContext$.MODULE$.apply(dashboard);
            this.scriptService.executeScript(scriptContext);
            dashboard2 = (Dashboard)((Object)scriptContext.getAttribute("dashboard"));
        } else {
            dashboard2 = dashboard;
        }
        return dashboard2;
    }

    private Dashboard provisionDashboardTiles(Dashboard dashboard) {
        dashboard.setTiles((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dashboard.getTiles()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> this.executeTileProvisionScript(dashboard, (Tile)((Object)x$3)), Buffer$.MODULE$.canBuildFrom())).asJava());
        return dashboard;
    }

    private Tile executeTileProvisionScript(Dashboard dashboard, Tile tile) {
        Tile tile2;
        String scriptLocation = tile.getProvisioningScriptLocation();
        if (Ids.isNullId((String)tile.getId()) && Strings.isNotBlank((String)scriptLocation)) {
            XlrScriptContext scriptContext = DashboardScriptContext$.MODULE$.apply(dashboard, tile);
            this.scriptService.executeScript(scriptContext);
            tile2 = (Tile)((Object)scriptContext.getAttribute("tile"));
        } else {
            tile2 = tile;
        }
        return tile2;
    }

    public static final /* synthetic */ boolean $anonfun$getDashboardTemplates$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Dashboard)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    public static final /* synthetic */ boolean $anonfun$evictTilesCache$2(Dashboard dashboard$1, SimpleKey key) {
        return key.toString().contains(dashboard$1.getId());
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$3(DashboardService $this, String cacheName$1, SimpleKey key) {
        $this.cacheManager.getCache(cacheName$1).evict((Object)key);
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$1(DashboardService $this, Dashboard dashboard$1, String cacheName) {
        Cache cache = (Cache)$this.cacheManager.getCache(cacheName).getNativeCache();
        ((IterableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(cache.asMap()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$evictTilesCache$2(dashboard$1, key)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            DashboardService.$anonfun$evictTilesCache$3($this, cacheName, key);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, CacheManager cacheManager, RoleService roleService, JythonScriptService scriptService, XLReleaseEventBus eventBus, CiIdService ciIdService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.cacheManager = cacheManager;
        this.roleService = roleService;
        this.scriptService = scriptService;
        this.eventBus = eventBus;
        this.ciIdService = ciIdService;
    }
}

