package com.xebialabs.xlrelease.chainofcustody.scmdata.strategy

import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService
import com.xebialabs.xlrelease.api.v1.FolderApi
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMEventHandlerUtils._
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMListenerStrategy
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.events.{FolderMovedEvent, FolderRenamedEvent, XLReleaseEvent}
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.repository.ReleaseRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Autowired
@Component
class SCMFolderEventHandler(
                          folderApi: FolderApi,
                          releaseRepository: ReleaseRepository,
                          scmTraceabilityService: SCMTraceabilityService
                        ) extends SCMListenerStrategy {

  override val updateFunction: Release => Release = releaseRepository.update

  override def isDefinedAt(event: XLReleaseEvent): Boolean = {
    event.isInstanceOf[FolderMovedEvent] || event.isInstanceOf[FolderRenamedEvent]
  }

  override def apply(event: XLReleaseEvent): Unit = {
    val folder = event match {
      case folderEvent: FolderMovedEvent => folderEvent.folder
      case folderEvent: FolderRenamedEvent => folderEvent.folder
    }
    processFolder(folder)
  }

  private def processFolder(folder: Folder): Unit = {
    val templates = folderApi.getTemplates(folder.getId, 0L, null, 1).asScala
    templates.foreach(deleteSCMDataAndUpdateRelease(_, updateFunction, scmTraceabilityService.persistOrDelete))
    folder.getChildren.asScala.foreach(processFolder)
  }
}
