package com.xebialabs.xlrelease.chainofcustody.scmdata.strategy

import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMEventHandlerUtils._
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMListenerStrategy
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.plugins.dashboard.events.{DashboardCreatedEvent, DashboardDeletedEvent, DashboardEvent, DashboardUpdatedEvent}
import com.xebialabs.xlrelease.repository.{Ids, ReleaseRepository}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Autowired
@Component
class DashboardEventHandler(
                             releaseRepository: ReleaseRepository,
                             scmTraceabilityService: SCMTraceabilityService
                           ) extends SCMListenerStrategy {

  override val updateFunction: Release => Release = releaseRepository.update

  override def isDefinedAt(event: XLReleaseEvent): Boolean = {
    event.isInstanceOf[DashboardEvent]
  }

  override def apply(event: XLReleaseEvent): Unit = {
    val dashboard = event match {
      case dashboardEvent: DashboardCreatedEvent => dashboardEvent.d
      case dashboardEvent: DashboardUpdatedEvent => dashboardEvent.d
      case dashboardEvent: DashboardDeletedEvent => dashboardEvent.d
    }

    Option(dashboard.getParentId).foreach(parentId =>
      if (Ids.isReleaseId(parentId)) {
        val template = releaseRepository.findById(dashboard.getParentId)
        deleteSCMDataAndUpdateRelease(template, updateFunction, scmTraceabilityService.persistOrDelete)
      }
    )
  }
}
