package com.xebialabs.xlrelease.api.internal;

import java.util.List;
import java.util.Map;

import com.xebialabs.xlrelease.api.internal.filter.LiveDeploymentFilters;
import com.xebialabs.xlrelease.api.internal.views.*;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.environments.Environment;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import org.springframework.data.domain.Page;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.environments.LiveDeployment;
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection;
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource;

@Path("/live-deployment")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface LiveDeploymentApi extends ApiService {

    default String serviceName() {
        return "liveDeploymentApi";
    }

    @GET
    Map<StatusHttpConnection, String> getConnectionErrors(@QueryParam("folderId") String folderId,
                                                          @DefaultValue("0") @QueryParam("max-age") Long maxAge);

    @GET
    @Path("/page")
    Page<LiveDeployment> getLiveDeployments(
            @QueryParam("folderId") String folderId,
            @DefaultValue("0") @QueryParam("max-age") Long maxAge,
            @DefaultValue("0") @QueryParam(PAGE) Integer page,
            @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Integer resultsPerPage,
            @DefaultValue("STATUS") @QueryParam(ORDER_BY) LiveDeploymentOrderMode orderBy,
            @DefaultValue("ASC") @QueryParam("order") LiveDeploymentOrderDirection direction,
            @DefaultValue("") @QueryParam("condition") String condition
    );

    @PUT
    @Path("/filters/{webhookSourceId:.*/Configuration[^/]*}")
    StatusWebhookEventSource saveWebhookSourceFilters(@PathParam("webhookSourceId") String webhookSourceId);

    @DELETE
    @Path("/delete/{webhookSourceId:.*/Configuration[^/]*}")
    void deleteWebhook(@PathParam("webhookSourceId") String webhookSourceId);

    @GET
    @Path("/count")
    Integer countLiveDeployments(
            @QueryParam("folderId") String folderId,
            @DefaultValue("") @QueryParam("condition") String condition
    );

    @GET
    @Path("/configs")
    Page<LiveDeploymentConfigView> getLiveDeploymentConfigs(
            @QueryParam("folderId") String folderId,
            @DefaultValue("0") @QueryParam(PAGE) Integer page,
            @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Integer resultsPerPage,
            @DefaultValue("STATUS") @QueryParam(ORDER_BY) LiveDeploymentConfigOrderMode orderBy,
            @DefaultValue("ASC") @QueryParam("order") LiveDeploymentOrderDirection direction,
            @DefaultValue("") @QueryParam("condition") String condition
    );

    @POST
    @Path("/search")
    List<LiveDeployment> searchLiveDeployments(LiveDeploymentFilters liveDeploymentFilters);

    @POST
    @Path("/search/environments")
    List<Environment> searchLiveDeploymentEnvironments(LiveDeploymentFilters liveDeploymentFilters);

    @POST
    @Path("/search/applications")
    List<Application> searchLiveDeploymentApplications(LiveDeploymentFilters liveDeploymentFilters);
}
